/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "brandom.h"


static GRand *brand = NULL;


void
b_rand_init(void)
{
  brand = g_rand_new();
}


void
b_rand_free(void)
{
  if (brand != NULL)
    g_rand_free(brand);
}


uint32_t
b_rand_int(void)
{
  return g_rand_int(brand);
}


uint32_t
b_rand_int_range(int32_t begin, int32_t end)
{
  return g_rand_int_range(brand, begin, end);
}


int
b_rand_boolean()
{
  return g_rand_boolean(brand);
}
