/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.ErrorEstimate;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryUnit;

public class BinaryReal
implements BinaryObject {
    public static final int computeBytes(Unit u, ErrorEstimate err) {
        return 18 + (u == null ? 0 : 5) + (err == null ? 0 : 5) + 1;
    }

    public static final Real read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache errorCache = reader.getErrorEstimateCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        BinaryObjectCache unitCache = reader.getUnitCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        RealType rt = (RealType)typeCache.get(typeIndex);
        double value = file.readDouble();
        Unit u = null;
        ErrorEstimate error = null;
        boolean reading = true;
        block7: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 30: {
                    int uIndex = file.readInt();
                    u = (Unit)unitCache.get(uIndex);
                    continue block7;
                }
                case 31: {
                    int eIndex = file.readInt();
                    error = (ErrorEstimate)errorCache.get(eIndex);
                    continue block7;
                }
                case 80: {
                    reading = false;
                    continue block7;
                }
            }
            throw new IOException("Unknown Real directive " + directive);
        }
        return new Real(rt, value, u, error);
    }

    public static final void writeDependentData(BinaryWriter writer, RealType type, Unit unit, ErrorEstimate error, Real real, Object token) throws IOException {
        BinaryRealType.write(writer, type, SAVE_DATA);
        if (unit != null) {
            BinaryUnit.write(writer, unit, SAVE_DATA);
        }
        if (error != null) {
            BinaryErrorEstimate.write(writer, error, SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter writer, RealType type, double value, Unit unit, ErrorEstimate error, Real real, Object token) throws IOException {
        BinaryReal.writeDependentData(writer, type, unit, error, real, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        int typeIndex = BinaryRealType.write(writer, type, token);
        int uIndex = -1;
        if (unit != null) {
            uIndex = BinaryUnit.write(writer, unit, token);
        }
        int errIndex = -1;
        if (error != null) {
            errIndex = BinaryErrorEstimate.write(writer, error, token);
        }
        int objLen = BinaryReal.computeBytes(unit, error);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(3);
        file.writeInt(typeIndex);
        file.writeDouble(value);
        if (uIndex >= 0) {
            file.writeByte(30);
            file.writeInt(uIndex);
        }
        if (errIndex >= 0) {
            file.writeByte(31);
            file.writeInt(errIndex);
        }
        file.writeByte(80);
    }
}

