/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.FunctionType;
import visad.MathType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;

public class BinaryFunctionType
implements BinaryObject {
    public static final int computeBytes(FunctionType ft) {
        return 14;
    }

    public static final FunctionType read(BinaryReader reader, int index) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int domainIndex = file.readInt();
        MathType domain = (MathType)cache.get(domainIndex);
        int rangeIndex = file.readInt();
        MathType range = (MathType)cache.get(rangeIndex);
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no TupleType end-marker)");
        }
        FunctionType ft = new FunctionType(domain, range);
        cache.add(index, ft);
        return ft;
    }

    public static final int write(BinaryWriter writer, FunctionType ft, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(ft);
        if (index < 0) {
            index = cache.add(ft);
            if (index < 0) {
                throw new IOException("Couldn't cache FunctionType " + ft);
            }
            int dIndex = BinaryMathType.write(writer, ft.getDomain(), token);
            int rIndex = BinaryMathType.write(writer, ft.getRange(), token);
            int objLen = BinaryFunctionType.computeBytes(ft);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(1);
            file.writeInt(dIndex);
            file.writeInt(rIndex);
            file.writeByte(80);
        }
        return index;
    }
}

