/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import visad.CommonUnit;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public final class DateTime
extends Real {
    private static Class dateFormatClass;
    public static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final TimeZone DEFAULT_TIMEZONE;
    private static String formatPattern;
    private static TimeZone timeZone;
    private GregorianCalendar utcCalendar;
    private static final double secondsPerDay = 86400.0;

    public DateTime(Real real) throws VisADException {
        super(RealType.Time, real.getValue(CommonUnit.secondsSinceTheEpoch), CommonUnit.secondsSinceTheEpoch, null);
    }

    public DateTime(double seconds) throws VisADException {
        super(RealType.Time, seconds, CommonUnit.secondsSinceTheEpoch, null, false);
    }

    public DateTime(double timeValue, Unit timeUnits) throws VisADException {
        this(new Real(RealType.Time, timeValue, timeUnits));
    }

    public DateTime(Date date) throws VisADException {
        super(RealType.Time, (double)date.getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch, null, false);
    }

    public DateTime() throws VisADException {
        this(new Real(RealType.Time, (double)System.currentTimeMillis() / 1000.0, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime(int year, int day, double seconds) throws VisADException {
        this(DateTime.fromYearDaySeconds(year, day, seconds));
    }

    public static Real fromYearDaySeconds(int year, int day, double seconds) throws VisADException {
        if (day < 1) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid day");
        }
        if (seconds > 86400.0 || seconds < 0.0) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid seconds");
        }
        return DateTime.fromYearDaySecondsTrusted(year, day, seconds);
    }

    private static Real fromYearDaySecondsTrusted(int year, int day, double seconds) throws VisADException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTimeZone(DEFAULT_TIMEZONE);
        if (year == 0) {
            year = -1;
        }
        cal.set(0, year < 0 ? 0 : 1);
        cal.set(1, Math.abs(year));
        cal.setLenient(true);
        cal.set(6, day);
        int temp = (int)Math.round(seconds * 1000.0);
        int secs = temp / 1000;
        int millis = temp % 1000;
        cal.set(13, secs);
        cal.set(14, millis);
        return new Real(RealType.Time, (double)cal.getTime().getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch);
    }

    public Real getReal() {
        return this;
    }

    private Calendar getCalendar() {
        if (this.utcCalendar == null) {
            this.utcCalendar = new GregorianCalendar(DEFAULT_TIMEZONE);
            this.utcCalendar.setTime(new Date(Math.round(this.getValue() * 1000.0)));
        }
        return this.utcCalendar;
    }

    public String toString() {
        String pat = formatPattern;
        if (formatPattern.equals(DEFAULT_TIME_FORMAT)) {
            pat = timeZone.equals(DEFAULT_TIMEZONE) ? "yyyy-MM-dd HH:mm:ss'Z'" : pat + " z";
            if (this.getCalendar().get(0) == 0) {
                pat = pat + " 'BCE'";
            }
        }
        return this.formattedString(pat, timeZone);
    }

    public String toValueString() {
        return this.toString();
    }

    public String formattedString(String pattern, TimeZone timezone) {
        StringBuffer buf = new StringBuffer();
        DateFormat sdf = null;
        if (dateFormatClass != null) {
            try {
                sdf = (DateFormat)dateFormatClass.newInstance();
            }
            catch (Exception ie) {
                throw new IllegalStateException("Error creating a DateFormat from:" + dateFormatClass.getName() + " " + ie);
            }
        } else {
            sdf = new SimpleDateFormat();
        }
        sdf.setTimeZone(timezone);
        if (pattern != null && sdf instanceof SimpleDateFormat) {
            ((SimpleDateFormat)sdf).applyPattern(pattern);
        }
        return sdf.format(this.getCalendar().getTime(), buf, new FieldPosition(0)).toString();
    }

    public String dateString() {
        String pattern = this.getCalendar().get(0) == 0 ? "yyyy-MM-dd 'BCE'" : "yyyy-MM-dd";
        return this.formattedString(pattern, DEFAULT_TIMEZONE);
    }

    public String timeString() {
        return this.formattedString("HH:mm:ss'Z'", DEFAULT_TIMEZONE);
    }

    public static void setDateFormatClass(Class dateFormatClass) {
        if (!DateFormat.class.isAssignableFrom(dateFormatClass)) {
            throw new IllegalArgumentException("Not a DateFormat class: " + dateFormatClass.getName());
        }
        DateTime.dateFormatClass = dateFormatClass;
    }

    public static void setFormatPattern(String pattern) {
        formatPattern = pattern;
    }

    public static String getFormatPattern() {
        return formatPattern;
    }

    public static void setFormatTimeZone(TimeZone tz) {
        timeZone = tz;
    }

    public static TimeZone getFormatTimeZone() {
        return timeZone;
    }

    public static void resetFormat() {
        formatPattern = DEFAULT_TIME_FORMAT;
        timeZone = DEFAULT_TIMEZONE;
    }

    public static DateTime createDateTime(String dateString) throws VisADException {
        return DateTime.createDateTime(dateString, formatPattern, DEFAULT_TIMEZONE);
    }

    public static DateTime createDateTime(String dateString, String format) throws VisADException {
        return DateTime.createDateTime(dateString, format, DEFAULT_TIMEZONE);
    }

    public static DateTime createDateTime(String dateString, String format, TimeZone timezone) throws VisADException {
        Date d;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(timezone);
            sdf.applyPattern(format);
            d = sdf.parse(dateString);
        }
        catch (ParseException pe) {
            throw new VisADException("invalid date string: " + dateString);
        }
        return new DateTime(d);
    }

    public int compareTo(Object oo) {
        return super.compareTo(oo);
    }

    public static Gridded1DDoubleSet makeTimeSet(DateTime[] times) throws VisADException {
        Arrays.sort(times);
        double[][] timeValues = new double[1][times.length];
        for (int i = 0; i < times.length; ++i) {
            timeValues[0][i] = times[i].getValue(CommonUnit.secondsSinceTheEpoch);
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, timeValues, times.length);
    }

    public static Gridded1DDoubleSet makeTimeSet(double[] times) throws VisADException {
        Arrays.sort(times);
        double[][] alltimes = new double[1][times.length];
        for (int i = 0; i < times.length; ++i) {
            alltimes[0][i] = times[i];
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, alltimes, times.length);
    }

    public static DateTime[] timeSetToArray(Gridded1DSet timeSet) throws VisADException {
        Unit unit = timeSet.getSetUnits()[0];
        if (!Unit.canConvert(unit, CommonUnit.secondsSinceTheEpoch)) {
            throw new VisADException("Invalid Units for timeSet");
        }
        double[][] values = !unit.equals(CommonUnit.secondsSinceTheEpoch) ? Unit.convertTuple(timeSet.getDoubles(), new Unit[]{unit}, new Unit[]{CommonUnit.secondsSinceTheEpoch}, false) : timeSet.getDoubles();
        DateTime[] times = new DateTime[timeSet.getLength()];
        for (int i = 0; i < timeSet.getLength(); ++i) {
            times[i] = new DateTime(values[0][i]);
        }
        return times;
    }

    public static void main(String[] args) throws VisADException {
        Real r;
        System.out.println("\nInitialized using DateTime(1959, 284, 36600.):");
        DateTime a = new DateTime(1959, 284, 36600.0);
        System.out.println("\n\ttoString()        = " + a + "\n\tdateString()      = " + a.dateString() + "\n\ttimeString()      = " + a.timeString() + "\n\tformattedString() = " + a.formattedString("(EEE) dd-MMM-yy hh:mm:SS.sss z", TimeZone.getTimeZone("EST")) + "\n\t  (using pattern " + "'(EEE) dd-MMM-yy hh:mm:SS.sss z' and timezone 'EST')");
        System.out.println("\nIncrementing 5 times by 20 days each time:\n");
        for (int i = 0; i < 5; ++i) {
            r = new Real(RealType.Time, a.getValue() + 1728000.0, CommonUnit.secondsSinceTheEpoch);
            a = new DateTime(r);
            System.out.println("\t" + a);
        }
        System.out.println("\nInitialized using Real of RealType.Time but no Unit (backward compatibility):");
        r = new Real(RealType.Time, a.getValue() + 86400.0);
        a = new DateTime(r);
        System.out.println("\n\t" + a);
        System.out.println("\nInitialized with a BCE date DateTime(-5, 196, 24493.):");
        a = new DateTime(-5, 193, 24493.0);
        System.out.println("\n\ttoString()        = " + a + "\n\tdateString()      = " + a.dateString() + "\n\ttimeString()      = " + a.timeString());
        Date date = new Date();
        a = new DateTime(date);
        System.out.println("\nInitialized with current Date(): " + a);
        a = new DateTime((double)date.getTime() / 1000.0);
        System.out.println("\nInitialized with current seconds since the epoch: " + a + "\n");
        a = DateTime.createDateTime(a.toString());
        System.out.println("\nUsing createDateTime with string of current Date(): " + a);
    }

    static {
        DEFAULT_TIMEZONE = TimeZone.getTimeZone("GMT");
        formatPattern = DEFAULT_TIME_FORMAT;
        timeZone = DEFAULT_TIMEZONE;
    }
}

