/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridEnsembleCoord {
    private static Logger log = LoggerFactory.getLogger(GridEnsembleCoord.class);
    private String name;
    private GridTableLookup lookup;
    private int ensembles = -1;
    private int[] ensTypes;
    private int pdn = -1;
    private int seq = 0;

    GridEnsembleCoord(GridRecord record, GridTableLookup lookup) {
        this.lookup = lookup;
        if (record instanceof GribGridRecord) {
            GribGridRecord ggr = (GribGridRecord)record;
            if (ggr.getEnsembleNumber() == -9999) {
                this.ensembles = -1;
                return;
            }
            this.ensembles = ggr.getNumberForecasts();
        }
    }

    GridEnsembleCoord(List<GridRecord> records, GridTableLookup lookup) {
        this.lookup = lookup;
        GridRecord gr = records.get(0);
        if (gr instanceof GribGridRecord) {
            this.calEnsembles(records);
        }
    }

    private void calEnsembles(List<GridRecord> records) {
        int[] enstypes = new int[100];
        this.ensembles = -1;
        for (GridRecord gr : records) {
            GribGridRecord ggr = (GribGridRecord)gr;
            this.pdn = ggr.productType;
            int ensNumber = ggr.getEnsembleNumber();
            if (ensNumber == -9999) {
                this.ensembles = -1;
                return;
            }
            if (this.ensembles < ensNumber) {
                this.ensembles = ensNumber;
            }
            enstypes[ensNumber] = ggr.getEnsembleType();
        }
        ++this.ensembles;
        this.ensTypes = new int[this.ensembles];
        System.arraycopy(enstypes, 0, this.ensTypes, 0, this.ensembles);
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.seq == 0 ? "ens" : "ens" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNEnsembles(), true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDataType(DataType.STRING);
        v.addAttribute(new Attribute("long_name", "ensemble"));
        String[] data = new String[this.ensembles];
        for (int i = 0; i < this.ensembles; ++i) {
            data[i] = Grib2Tables.getEnsembleType(this.pdn, this.ensTypes[i]) + " " + Integer.toString(i);
        }
        Array dataArray = Array.factory(DataType.STRING, new int[]{this.ensembles}, (Object)data);
        v.setDimensions(v.getShortName());
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        ncfile.addVariable(g, v);
    }

    int getIndex(GridRecord record) {
        if (record instanceof GribGridRecord) {
            GribGridRecord ggr = (GribGridRecord)record;
            int en = ggr.getEnsembleNumber();
            if (en == -9999) {
                return 0;
            }
            return en;
        }
        return -1;
    }

    int getNEnsembles() {
        return this.ensembles;
    }

    int getPDN() {
        return this.pdn;
    }

    int[] getEnsType() {
        return this.ensTypes;
    }
}

