/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.bounce.image.BlueFilter;
import org.bounce.image.BrighterFilter;
import org.bounce.image.CyanFilter;
import org.bounce.image.DarkerFilter;
import org.bounce.image.GrayFilter;
import org.bounce.image.GreenFilter;
import org.bounce.image.MagentaFilter;
import org.bounce.image.RedFilter;
import org.bounce.image.SilhouetteFilter;
import org.bounce.image.YellowFilter;

public class ImageUtilities {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_PERCENTAGE = 30;

    public static ImageIcon createDarkerImage(ImageIcon image) {
        return ImageUtilities.filter(image, new DarkerFilter(30));
    }

    public static ImageIcon createBrighterImage(ImageIcon image) {
        return ImageUtilities.filter(image, new BrighterFilter(30));
    }

    public static ImageIcon createGrayImage(ImageIcon image) {
        return ImageUtilities.filter(image, new GrayFilter(30));
    }

    public static ImageIcon createRedImage(ImageIcon image) {
        return ImageUtilities.filter(image, new RedFilter(30));
    }

    public static ImageIcon createGreenImage(ImageIcon image) {
        return ImageUtilities.filter(image, new GreenFilter(30));
    }

    public static ImageIcon createBlueImage(ImageIcon image) {
        return ImageUtilities.filter(image, new BlueFilter(30));
    }

    public static ImageIcon createCyanImage(ImageIcon image) {
        return ImageUtilities.filter(image, new CyanFilter(30));
    }

    public static ImageIcon createMagentaImage(ImageIcon image) {
        return ImageUtilities.filter(image, new MagentaFilter(30));
    }

    public static ImageIcon createYellowImage(ImageIcon image) {
        return ImageUtilities.filter(image, new YellowFilter(30));
    }

    public static ImageIcon createSilhouetteImage(ImageIcon image, Color color) {
        return ImageUtilities.filter(image, new SilhouetteFilter(color));
    }

    public static ImageIcon filter(ImageIcon image, RGBImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getImage().getSource(), filter);
        ImageIcon filteredImage = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
        return filteredImage;
    }

    public static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static Icon resize(Icon icon, int width, int height) {
        if (icon == null) {
            return icon;
        }
        if (!(height > 0 && height != icon.getIconHeight() || width > 0 && width != icon.getIconWidth())) {
            return icon;
        }
        Image image = ImageUtilities.iconToImage(icon);
        if (height <= 0) {
            height = (int)((float)icon.getIconHeight() / (float)(icon.getIconWidth() / width));
        }
        if (width <= 0) {
            width = (int)((float)icon.getIconWidth() / (float)(icon.getIconHeight() / height));
        }
        return new ImageIcon(image.getScaledInstance(width, height, 4));
    }
}

