/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;

public class EPSWriter
extends FormatWriter {
    protected RandomAccessFile out;

    public EPSWriter() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi"});
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        if (image == null) {
            throw new FormatException("Image is null");
        }
        this.out = new RandomAccessFile(this.currentId, "rw");
        BufferedImage img = this.cm == null ? ImageTools.makeBuffered(image) : ImageTools.makeBuffered(image, this.cm);
        int width = img.getWidth();
        int height = img.getHeight();
        byte[][] byteData = ImageTools.getBytes(img);
        DataTools.writeString(this.out, "%!PS-Adobe-2.0 EPSF-1.2\n");
        DataTools.writeString(this.out, "%%Title: " + this.currentId + "\n");
        DataTools.writeString(this.out, "%%Creator: LOCI Bio-Formats\n");
        DataTools.writeString(this.out, "%%Pages: 1\n");
        DataTools.writeString(this.out, "%%BoundingBox: 0 0 " + width + " " + height + "\n");
        DataTools.writeString(this.out, "%%EndComments\n\n");
        DataTools.writeString(this.out, "/ld {load def} bind def\n");
        DataTools.writeString(this.out, "/s /stroke ld /f /fill ld /m /moveto ld /l /lineto ld /c /curveto ld /rgb {255 div 3 1 roll 255 div 3 1 roll 255 div 3 1 roll setrgbcolor} def\n");
        DataTools.writeString(this.out, "0 0 translate\n");
        DataTools.writeString(this.out, (float)width + " " + (float)height + " scale\n");
        DataTools.writeString(this.out, "/picstr 40 string def\n");
        if (byteData.length == 1) {
            DataTools.writeString(this.out, width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr " + "readhexstring pop} image\n");
            int charCount = 0;
            for (int i = 0; i < byteData[0].length; ++i) {
                for (int j = 0; j < 1; ++j) {
                    String s = Integer.toHexString(byteData[j][i]);
                    s = s.length() > 1 ? s.substring(s.length() - 2) : "0" + s;
                    DataTools.writeString(this.out, s);
                    if (++charCount != 40) continue;
                    DataTools.writeString(this.out, "\n");
                    charCount = 0;
                }
            }
        } else {
            DataTools.writeString(this.out, width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr " + "readhexstring pop} false 3 colorimage\n");
            int charCount = 0;
            for (int i = 0; i < byteData[0].length; ++i) {
                for (int j = 0; j < byteData.length; ++j) {
                    String s = Integer.toHexString(byteData[j][i]);
                    s = s.length() > 1 ? s.substring(s.length() - 2) : "0" + s;
                    DataTools.writeString(this.out, s);
                    if (++charCount != 40) continue;
                    DataTools.writeString(this.out, "\n");
                    charCount = 0;
                }
            }
        }
        DataTools.writeString(this.out, "showpage\n");
        this.out.close();
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

