/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class KhorosReader
extends FormatReader {
    private byte[] lut;
    private long offset;

    public KhorosReader() {
        super("Khoros XV", "xv");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == -85 && block[1] == 1;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null) {
            return null;
        }
        byte[][] table = new byte[3][this.lut.length / 3];
        int next = 0;
        for (int i = 0; i < table[0].length; ++i) {
            for (int j = 0; j < table.length; ++j) {
                table[j][i] = this.lut[next++];
            }
        }
        return table;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int bufSize = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        this.in.seek(this.offset + (long)(no * bufSize));
        this.in.read(buf, 0, bufSize);
        return buf;
    }

    public void close() throws IOException {
        super.close();
        this.lut = null;
        this.offset = 0L;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.skipBytes(4);
        this.in.order(true);
        int dependency = this.in.readInt();
        this.addMeta("Comment", this.in.readString(512));
        this.in.order(dependency == 4 || dependency == 8);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.in.skipBytes(28);
        this.core.imageCount[0] = this.in.readInt();
        if (this.core.imageCount[0] == 0) {
            this.core.imageCount[0] = 1;
        }
        this.core.sizeC[0] = this.in.readInt();
        int type = this.in.readInt();
        switch (type) {
            case 0: 
            case 1: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 4: {
                this.core.pixelType[0] = 5;
                break;
            }
            case 5: {
                this.core.pixelType[0] = 6;
                break;
            }
            case 9: {
                this.core.pixelType[0] = 7;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type : " + type);
            }
        }
        this.in.skipBytes(12);
        int c = this.in.readInt();
        if (c > 1) {
            this.core.sizeC[0] = c;
            int n = this.in.readInt();
            this.lut = new byte[n * c];
            this.in.skipBytes(436);
            for (i = 0; i < this.lut.length; ++i) {
                int value = this.in.read();
                if (i < n) {
                    this.lut[i * 3] = (byte)value;
                    this.lut[i * 3 + 1] = (byte)value;
                    this.lut[i * 3 + 2] = (byte)value;
                    continue;
                }
                if (i < n * 2) {
                    this.lut[i % n * 3 + 1] = (byte)value;
                    continue;
                }
                if (i >= n * 3) continue;
                this.lut[i % n * 3 + 2] = (byte)value;
            }
        } else {
            this.in.skipBytes(440);
        }
        this.offset = this.in.getFilePointer();
        this.core.sizeZ[0] = this.core.imageCount[0];
        this.core.sizeT[0] = 1;
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = dependency == 4 || dependency == 8;
        this.core.currentOrder[0] = "XYCZT";
        this.core.indexed[0] = this.lut != null;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

