/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.data.mcidas.McIDASGridDirectory;

public class AddeGridReader {
    private DataInputStream dis;
    private int status = 0;
    private URLConnection urlc;
    private char[] data;
    private final int HEARTBEAT = 11223344;
    ArrayList fileHeaders;
    ArrayList gridHeaders;
    ArrayList gridData;

    public ArrayList getGridDirectory(String request) throws AddeURLException {
        this.gridHeaders = new ArrayList();
        this.fileHeaders = new ArrayList();
        try {
            URL url = new URL(request);
            this.urlc = url.openConnection();
            InputStream is = this.urlc.getInputStream();
            this.dis = new DataInputStream(new BufferedInputStream(is));
        }
        catch (AddeURLException ae) {
            throw new AddeURLException("Dataset not found: " + ae);
        }
        catch (Exception e) {
            throw new AddeURLException("Error opening connection: " + e);
        }
        int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
        if (numBytes == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        try {
            int check;
            byte[] header = new byte[256];
            while (numBytes == 4) {
                check = this.dis.readInt();
                if (check != 11223344) {
                    System.out.println("problem...not heartbeat = " + check);
                }
                numBytes = this.dis.readInt();
            }
            while ((check = this.dis.readInt()) == 0) {
                int check2;
                this.dis.readFully(header, 0, 256);
                String head = new String(header, 0, 32);
                this.fileHeaders.add(head);
                while ((check2 = this.dis.readInt()) == 0) {
                    this.dis.readFully(header, 0, 256);
                    String name = new String(header, 24, 4);
                    McIDASGridDirectory mg = new McIDASGridDirectory(header);
                    this.gridHeaders.add(mg);
                }
            }
        }
        catch (Exception re) {
            System.out.println(re);
        }
        return this.gridHeaders;
    }

    public ArrayList getGridHeaders() {
        return this.gridHeaders;
    }

    public ArrayList getFileHeaders() {
        return this.fileHeaders;
    }

    public ArrayList getGridData(String request) throws AddeURLException {
        this.gridHeaders = new ArrayList();
        this.gridData = new ArrayList();
        try {
            URL url = new URL(request);
            this.urlc = url.openConnection();
            InputStream is = this.urlc.getInputStream();
            this.dis = new DataInputStream(new BufferedInputStream(is));
        }
        catch (AddeURLException ae) {
            throw new AddeURLException("Dataset not found: " + ae);
        }
        catch (Exception e) {
            throw new AddeURLException("Error opening connection: " + e);
        }
        int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
        if (numBytes == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        try {
            int check;
            byte[] header = new byte[256];
            while (numBytes == 4) {
                check = this.dis.readInt();
                if (check != 11223344) {
                    System.out.println("problem...not heartbeat = " + check);
                }
                numBytes = this.dis.readInt();
            }
            int checkBytes = this.dis.readInt();
            if (checkBytes != numBytes) {
                throw new AddeURLException("Invalid number of bytes returned for grid.");
            }
            int numGrids = this.dis.readInt();
            for (int i = 0; i < numGrids; ++i) {
                this.dis.readFully(header, 0, 256);
                String name = new String(header, 24, 4);
                McIDASGridDirectory mg = new McIDASGridDirectory(header);
                System.out.println(mg.toString());
                CoordinateSystem c = mg.getCoordinateSystem();
                this.gridHeaders.add(mg);
                int rows = mg.getRows();
                int cols = mg.getColumns();
                double scale = mg.getParamScale();
                double[] ddata = new double[rows * cols];
                boolean n = false;
                for (int nc = 0; nc < cols; ++nc) {
                    for (int nr = 0; nr < rows; ++nr) {
                        int temp = this.dis.readInt();
                        ddata[(rows - nr - 1) * cols + nc] = temp == -2139062144 ? Double.NaN : (double)temp / scale;
                    }
                }
                this.gridData.add(ddata);
                check = this.dis.readInt();
                if (check == 0) {
                    continue;
                }
                break;
            }
        }
        catch (Exception re) {
            System.out.println(re);
        }
        return this.gridData;
    }

    public static void main(String[] args) throws Exception {
        String request = args.length == 0 ? "adde://sweetpea.ssec.wisc.edu/grid?group=ABOM&descr=GRIDS&pos=302&num=40&lev=500&proj=6999&user=tomw&" : args[0];
        AddeGridReader d = new AddeGridReader();
        ArrayList v = d.getGridData(request);
        ArrayList vd = d.getGridHeaders();
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

