#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("moves review to the previous line ")

    def run(self):
        self.env["runtime"][
            "CursorManager"
        ].enter_review_mode_curr_text_cursor()

        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            prev_line,
            end_of_screen,
        ) = line_utils.get_prev_line(
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )

        if prev_line.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True, flush=False
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                prev_line, interrupt=True, flush=False
            )
        if end_of_screen:
            if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                "review", "end_of_screen"
            ):
                self.env["runtime"]["OutputManager"].present_text(
                    _("end of screen"),
                    interrupt=True,
                    sound_icon="EndOfScreen",
                )

    def set_callback(self, callback):
        pass
