/*
// $Id: //open/dev/farrago/src/org/eigenbase/oj/stmt/PreparedExecution.java#12 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2002-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.oj.stmt;

import java.lang.reflect.*;

import openjava.ptree.*;

import org.eigenbase.rel.*;
import org.eigenbase.reltype.*;
import org.eigenbase.util.*;


/**
 * PreparedExecution is a PreparedResult of a statement for which Java code was
 * generated by preparation.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/oj/stmt/PreparedExecution.java#12 $
 */
public class PreparedExecution
    implements PreparedResult
{
    //~ Instance fields --------------------------------------------------------

    private final ParseTree parseTree;
    private final RelNode rootRel;
    private final RelDataType rowType;
    private final boolean isDml;
    private final TableModificationRel.Operation tableModOp;
    private final BoundMethod boundMethod;

    //~ Constructors -----------------------------------------------------------

    PreparedExecution(
        ParseTree parseTree,
        RelNode rootRel,
        RelDataType rowType,
        boolean isDml,
        TableModificationRel.Operation tableModOp,
        BoundMethod boundMethod)
    {
        this.parseTree = parseTree;
        this.rootRel = rootRel;
        this.rowType = rowType;
        this.isDml = isDml;
        this.tableModOp = tableModOp;
        this.boundMethod = boundMethod;
    }

    //~ Methods ----------------------------------------------------------------

    public String getCode()
    {
        return parseTree.toString();
    }

    public boolean isDml()
    {
        return isDml;
    }

    public TableModificationRel.Operation getTableModOp()
    {
        return tableModOp;
    }

    /**
     * Returns the physical row type of this prepared statement. May not be
     * identical to the row type returned by the validator; for example, the
     * field names may have been made unique.
     */
    public RelDataType getPhysicalRowType()
    {
        return rowType;
    }

    public Method getMethod()
    {
        return boundMethod.method;
    }

    public RelNode getRootRel()
    {
        return rootRel;
    }

    public Object execute()
    {
        try {
            return boundMethod.call();
        } catch (IllegalAccessException e) {
            throw Util.newInternal(e);
        } catch (InvocationTargetException e) {
            throw Util.newInternal(e);
        }
    }

    public void setArgs(Object [] args)
    {
        boundMethod.args = args;
    }
}

// End PreparedExecution.java
