/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;

using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Diagnostic;
using Db4objects.Db4o.TA;

namespace Db4ojects.Db4odoc.TAExamples
{
    public class TAExample
    {

        private const string Db4oFileName = "reference.db4o";

        private static IObjectContainer _container = null;

        public static void Main(string[] args)
        {
            TestActivation();
        }
        // end Main

        private static void StoreSensorPanel()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Database(Db4oFactory.NewConfiguration());
            if (container != null)
            {
                try
                {
                    // create a linked list with length 10
                    SensorPanelTA list = new SensorPanelTA().CreateList(10);
                    container.Set(list);
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }

        // end StoreSensorPanel

  
        private static IConfiguration ConfigureTA()
        {
            IConfiguration configuration = Db4oFactory.NewConfiguration();
            // set normal activation to 0
            configuration.ActivationDepth(0);
            // add TA support
            configuration.Add(new TransparentActivationSupport());
            return configuration;
        }
        // end ConfigureTA

        private static void TestActivation()
        {
            StoreSensorPanel();
            IConfiguration configuration = ConfigureTA();

            IObjectContainer container = Database(configuration);
            if (container != null)
            {
                try
                {
                    System.Console.WriteLine("Zero activation depth");
                    IObjectSet result = container.Get(new SensorPanelTA(1));
                    ListResult(result);
                    if (result.Size() > 0)
                    {
                        SensorPanelTA sensor = (SensorPanelTA)result[0];
                        // the object is a linked list, so each call to next()
                        // will need to activate a new object
                        SensorPanelTA next = sensor.Next;
                        while (next != null)
                        {
                            System.Console.WriteLine(next);
                            next = next.Next;
                        }
                    }
                }
                finally
                {
                    CloseDatabase();
                }
            }
        }

        // end TestActivation

        
        private static IObjectContainer Database(IConfiguration configuration)
        {
            if (_container == null)
            {
                try
                {
                    _container = Db4oFactory.OpenFile(configuration, Db4oFileName);
                }
                catch (DatabaseFileLockedException ex)
                {
                    System.Console.WriteLine(ex.Message);
                }
            }
            return _container;
        }

        // end Database

        private static void CloseDatabase()
        {
            if (_container != null)
            {
                _container.Close();
                _container = null;
            }
        }

        // end CloseDatabase

        private static void ListResult(IObjectSet result)
        {
            System.Console.WriteLine(result.Size());
            while (result.HasNext())
            {
                System.Console.WriteLine(result.Next());
            }
        }
        // end ListResult
    }
}
