/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_phy_control_regs.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:21 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_phy_control_regs.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_PHY_CONTROL_REGS_H__
#define BCHP_DDR23_PHY_CONTROL_REGS_H__

/***************************************************************************
 *DDR23_PHY_CONTROL_REGS - DDR23 DDR23 physical interface control registers
 ***************************************************************************/
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION     0x01801000 /* Address & Control revision register */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL  0x01801004 /* PHY clock power management control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS   0x01801010 /* PHY PLL status register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG   0x01801014 /* PHY PLL configuration register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER 0x01801018 /* PHY PLL pre-divider control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER  0x0180101c /* PHY PLL divider control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1 0x01801020 /* PHY PLL analog control register #1 */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2 0x01801024 /* PHY PLL analog control register #2 */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_EN    0x01801028 /* PHY PLL spread spectrum config register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_CFG   0x0180102c /* PHY PLL spread spectrum config register */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE 0x01801030 /* Address & Control VDL static override control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE 0x01801034 /* Address & Control VDL dynamic override control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL 0x01801038 /* Idle mode SSTL pad control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL 0x0180103c /* PVT Compensation control and status register */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL 0x01801040 /* SSTL pad drive characteristics control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL 0x01801044 /* Clock Regulator control register */

/***************************************************************************
 *REVISION - Address & Control revision register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: REVISION :: reserved0 [31:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_reserved0_MASK        0xffff0000
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_reserved0_SHIFT       16

/* DDR23_PHY_CONTROL_REGS :: REVISION :: MAJOR [15:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_MAJOR_MASK            0x0000ff00
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_MAJOR_SHIFT           8

/* DDR23_PHY_CONTROL_REGS :: REVISION :: MINOR [07:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_MINOR_MASK            0x000000ff
#define BCHP_DDR23_PHY_CONTROL_REGS_REVISION_MINOR_SHIFT           0

/***************************************************************************
 *CLK_PM_CTRL - PHY clock power management control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: CLK_PM_CTRL :: reserved0 [31:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL_reserved0_MASK     0xfffffffe
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL_reserved0_SHIFT    1

/* DDR23_PHY_CONTROL_REGS :: CLK_PM_CTRL :: DIS_DDR_CLK [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL_DIS_DDR_CLK_MASK   0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL_DIS_DDR_CLK_SHIFT  0

/***************************************************************************
 *PLL_STATUS - PHY PLL status register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_STATUS :: reserved0 [31:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS_reserved0_MASK      0xfffffffe
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS_reserved0_SHIFT     1

/* DDR23_PHY_CONTROL_REGS :: PLL_STATUS :: LOCK [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS_LOCK_MASK           0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS_LOCK_SHIFT          0

/***************************************************************************
 *PLL_CONFIG - PHY PLL configuration register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: DIV2_CLK_RESET [31:31] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_DIV2_CLK_RESET_MASK 0x80000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_DIV2_CLK_RESET_SHIFT 31

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: reserved0 [30:22] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved0_MASK      0x7fc00000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved0_SHIFT     22

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: TEST_SEL [21:17] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_TEST_SEL_MASK       0x003e0000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_TEST_SEL_SHIFT      17

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: TEST_EN [16:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_TEST_EN_MASK        0x00010000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_TEST_EN_SHIFT       16

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: BGAP_ADJ [15:12] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_BGAP_ADJ_MASK       0x0000f000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_BGAP_ADJ_SHIFT      12

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: reserved1 [11:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved1_MASK      0x00000f00
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved1_SHIFT     8

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: VCO_RNG [07:07] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_VCO_RNG_MASK        0x00000080
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_VCO_RNG_SHIFT       7

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: PWRDN_CH1 [06:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_PWRDN_CH1_MASK      0x00000040
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_PWRDN_CH1_SHIFT     6

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: BYPEN [05:05] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_BYPEN_MASK          0x00000020
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_BYPEN_SHIFT         5

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: ENB_CLKOUT [04:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_ENB_CLKOUT_MASK     0x00000010
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_ENB_CLKOUT_SHIFT    4

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: DRESET [03:03] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_DRESET_MASK         0x00000008
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_DRESET_SHIFT        3

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: ARESET [02:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_ARESET_MASK         0x00000004
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_ARESET_SHIFT        2

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: reserved2 [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved2_MASK      0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_reserved2_SHIFT     1

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: PWRDN [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_PWRDN_MASK          0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_PWRDN_SHIFT         0

/***************************************************************************
 *PLL_PRE_DIVIDER - PHY PLL pre-divider control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: reserved0 [31:27] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved0_MASK 0xf8000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved0_SHIFT 27

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: NDIV_DITHER_MFB [26:26] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_DITHER_MFB_MASK 0x04000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_DITHER_MFB_SHIFT 26

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: NDIV_PWRDN [25:25] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_PWRDN_MASK 0x02000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_PWRDN_SHIFT 25

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: reserved1 [24:23] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved1_MASK 0x01800000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved1_SHIFT 23

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: NDIV_MODE [22:20] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_MODE_MASK 0x00700000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_MODE_SHIFT 20

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: reserved2 [19:17] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved2_MASK 0x000e0000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_reserved2_SHIFT 17

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: NDIV_INT [16:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_INT_MASK  0x0001ff00
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_NDIV_INT_SHIFT 8

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: P2DIV [07:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_P2DIV_MASK     0x000000f0
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_P2DIV_SHIFT    4

/* DDR23_PHY_CONTROL_REGS :: PLL_PRE_DIVIDER :: P1DIV [03:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_P1DIV_MASK     0x0000000f
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER_P1DIV_SHIFT    0

/***************************************************************************
 *PLL_DIVIDER - PHY PLL divider control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_DIVIDER :: M1DIV [31:24] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER_M1DIV_MASK         0xff000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER_M1DIV_SHIFT        24

/* DDR23_PHY_CONTROL_REGS :: PLL_DIVIDER :: NDIV_FRAC [23:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER_NDIV_FRAC_MASK     0x00ffffff
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER_NDIV_FRAC_SHIFT    0

/***************************************************************************
 *PLL_CONTROL1 - PHY PLL analog control register #1
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: TESTA_SEL [31:30] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_TESTA_SEL_MASK    0xc0000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_TESTA_SEL_SHIFT   30

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: KVCO_XS [29:27] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_KVCO_XS_MASK      0x38000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_KVCO_XS_SHIFT     27

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: KVCO_XF [26:24] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_KVCO_XF_MASK      0x07000000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_KVCO_XF_SHIFT     24

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: LPF_BW [23:22] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_LPF_BW_MASK       0x00c00000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_LPF_BW_SHIFT      22

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: LF_ORDER [21:21] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_LF_ORDER_MASK     0x00200000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_LF_ORDER_SHIFT    21

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: CN [20:19] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CN_MASK           0x00180000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CN_SHIFT          19

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: RN [18:17] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_RN_MASK           0x00060000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_RN_SHIFT          17

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: CP [16:15] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CP_MASK           0x00018000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CP_SHIFT          15

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: CZ [14:13] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CZ_MASK           0x00006000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_CZ_SHIFT          13

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: RZ [12:10] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_RZ_MASK           0x00001c00
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_RZ_SHIFT          10

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: ICPX [09:05] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_ICPX_MASK         0x000003e0
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_ICPX_SHIFT        5

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL1 :: ICP_OFF [04:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_ICP_OFF_MASK      0x0000001f
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL1_ICP_OFF_SHIFT     0

/***************************************************************************
 *PLL_CONTROL2 - PHY PLL analog control register #2
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL2 :: reserved0 [31:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_reserved0_MASK    0xffffffc0
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_reserved0_SHIFT   6

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL2 :: PTAP_ADJ [05:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_PTAP_ADJ_MASK     0x00000030
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_PTAP_ADJ_SHIFT    4

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL2 :: CTAP_ADJ [03:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_CTAP_ADJ_MASK     0x0000000c
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_CTAP_ADJ_SHIFT    2

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL2 :: LOWCUR_EN [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_LOWCUR_EN_MASK    0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_LOWCUR_EN_SHIFT   1

/* DDR23_PHY_CONTROL_REGS :: PLL_CONTROL2 :: BIASIN_EN [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_BIASIN_EN_MASK    0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONTROL2_BIASIN_EN_SHIFT   0

/***************************************************************************
 *PLL_SS_EN - PHY PLL spread spectrum config register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_SS_EN :: reserved0 [31:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_EN_reserved0_MASK       0xfffffffe
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_EN_reserved0_SHIFT      1

/* DDR23_PHY_CONTROL_REGS :: PLL_SS_EN :: SS_EN [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_EN_SS_EN_MASK           0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_EN_SS_EN_SHIFT          0

/***************************************************************************
 *PLL_SS_CFG - PHY PLL spread spectrum config register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_SS_CFG :: REF_CYC_PER_TICK [31:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_CFG_REF_CYC_PER_TICK_MASK 0xffff0000
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_CFG_REF_CYC_PER_TICK_SHIFT 16

/* DDR23_PHY_CONTROL_REGS :: PLL_SS_CFG :: NDIV_AMP [15:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_CFG_NDIV_AMP_MASK       0x0000ffff
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_SS_CFG_NDIV_AMP_SHIFT      0

/***************************************************************************
 *STATIC_VDL_OVERRIDE - Address & Control VDL static override control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: reserved0 [31:21] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved0_MASK 0xffe00000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved0_SHIFT 21

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: ovr_force [20:20] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_force_MASK 0x00100000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_force_SHIFT 20

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: reserved1 [19:17] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved1_MASK 0x000e0000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved1_SHIFT 17

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: ovr_en [16:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_en_MASK 0x00010000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_en_SHIFT 16

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: reserved2 [15:14] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved2_MASK 0x0000c000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved2_SHIFT 14

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: ovr_fine_fall [13:12] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_fine_fall_MASK 0x00003000
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_fine_fall_SHIFT 12

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: reserved3 [11:10] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved3_MASK 0x00000c00
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved3_SHIFT 10

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: ovr_fine_rise [09:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_fine_rise_MASK 0x00000300
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_fine_rise_SHIFT 8

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: reserved4 [07:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved4_MASK 0x000000c0
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_reserved4_SHIFT 6

/* DDR23_PHY_CONTROL_REGS :: STATIC_VDL_OVERRIDE :: ovr_step [05:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_step_MASK 0x0000003f
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE_ovr_step_SHIFT 0

/***************************************************************************
 *DYNAMIC_VDL_OVERRIDE - Address & Control VDL dynamic override control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: reserved0 [31:17] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved0_MASK 0xfffe0000
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved0_SHIFT 17

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: ovr_en [16:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_en_MASK 0x00010000
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_en_SHIFT 16

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: reserved1 [15:14] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved1_MASK 0x0000c000
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved1_SHIFT 14

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: ovr_fine_fall [13:12] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_fine_fall_MASK 0x00003000
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_fine_fall_SHIFT 12

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: reserved2 [11:10] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved2_MASK 0x00000c00
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved2_SHIFT 10

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: ovr_fine_rise [09:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_fine_rise_MASK 0x00000300
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_fine_rise_SHIFT 8

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: reserved3 [07:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved3_MASK 0x000000c0
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_reserved3_SHIFT 6

/* DDR23_PHY_CONTROL_REGS :: DYNAMIC_VDL_OVERRIDE :: ovr_step [05:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_step_MASK 0x0000003f
#define BCHP_DDR23_PHY_CONTROL_REGS_DYNAMIC_VDL_OVERRIDE_ovr_step_SHIFT 0

/***************************************************************************
 *IDLE_PAD_CONTROL - Idle mode SSTL pad control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: idle [31:31] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_idle_MASK     0x80000000
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_idle_SHIFT    31

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: reserved0 [30:09] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved0_MASK 0x7ffffe00
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved0_SHIFT 9

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: rxenb [08:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_rxenb_MASK    0x00000100
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_rxenb_SHIFT   8

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: reserved1 [07:07] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved1_MASK 0x00000080
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved1_SHIFT 7

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: ctl_iddq [06:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_iddq_MASK 0x00000040
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_iddq_SHIFT 6

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: ctl_reb [05:05] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_reb_MASK  0x00000020
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_reb_SHIFT 5

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: ctl_oeb [04:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_oeb_MASK  0x00000010
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_oeb_SHIFT 4

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: reserved2 [03:03] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved2_MASK 0x00000008
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_reserved2_SHIFT 3

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: cke_iddq [02:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_iddq_MASK 0x00000004
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_iddq_SHIFT 2

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: cke_reb [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_reb_MASK  0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_reb_SHIFT 1

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: cke_oeb [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_oeb_MASK  0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_oeb_SHIFT 0

/***************************************************************************
 *ZQ_PVT_COMP_CTL - PVT Compensation control and status register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: reserved0 [31:31] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_reserved0_MASK 0x80000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_reserved0_SHIFT 31

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: pd_done [30:30] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_pd_done_MASK   0x40000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_pd_done_SHIFT  30

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: nd_done [29:29] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_nd_done_MASK   0x20000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_nd_done_SHIFT  29

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: sample_done [28:28] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_done_MASK 0x10000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_done_SHIFT 28

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: auto_sample_en [27:27] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_auto_sample_en_MASK 0x08000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_auto_sample_en_SHIFT 27

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: sample_en [26:26] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_en_MASK 0x04000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_en_SHIFT 26

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: addr_ovr_en [25:25] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_ovr_en_MASK 0x02000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_ovr_en_SHIFT 25

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: dq_ovr_en [24:24] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_ovr_en_MASK 0x01000000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_ovr_en_SHIFT 24

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: pd_comp [23:20] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_pd_comp_MASK   0x00f00000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_pd_comp_SHIFT  20

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: nd_comp [19:16] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_nd_comp_MASK   0x000f0000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_nd_comp_SHIFT  16

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: addr_pd_override_val [15:12] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_pd_override_val_MASK 0x0000f000
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_pd_override_val_SHIFT 12

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: addr_nd_override_val [11:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_nd_override_val_MASK 0x00000f00
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_addr_nd_override_val_SHIFT 8

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: dq_pd_override_val [07:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_pd_override_val_MASK 0x000000f0
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_pd_override_val_SHIFT 4

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: dq_nd_override_val [03:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_nd_override_val_MASK 0x0000000f
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_dq_nd_override_val_SHIFT 0

/***************************************************************************
 *DRIVE_PAD_CTL - SSTL pad drive characteristics control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: reserved0 [31:05] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_reserved0_MASK   0xffffffe0
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_reserved0_SHIFT  5

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: rt60b [04:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_rt60b_MASK       0x00000010
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_rt60b_SHIFT      4

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: sel_sstl18 [03:03] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_sel_sstl18_MASK  0x00000008
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_sel_sstl18_SHIFT 3

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: seltxdrv_ci [02:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_seltxdrv_ci_MASK 0x00000004
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_seltxdrv_ci_SHIFT 2

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: selrxdrv [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_selrxdrv_MASK    0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_selrxdrv_SHIFT   1

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: slew [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_slew_MASK        0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_slew_SHIFT       0

/***************************************************************************
 *CLOCK_REG_CONTROL - Clock Regulator control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: CLOCK_REG_CONTROL :: reserved0 [31:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_reserved0_MASK 0xfffffffc
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_reserved0_SHIFT 2

/* DDR23_PHY_CONTROL_REGS :: CLOCK_REG_CONTROL :: half_power [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_half_power_MASK 0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_half_power_SHIFT 1

/* DDR23_PHY_CONTROL_REGS :: CLOCK_REG_CONTROL :: pwrdn [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_pwrdn_MASK   0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_pwrdn_SHIFT  0

#endif /* #ifndef BCHP_DDR23_PHY_CONTROL_REGS_H__ */

/* End of File */
