/* $Id: kmo_priv_flat.h,v 1.9 2013-10-10 11:14:39 aagudo Exp $
 *
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-10-10 11:14:39 $
 * $Revision: 1.9 $
 * $Name: not supported by cvs2svn $
 */

#ifndef KMOS_PRIV_FLAT_H
#define KMOS_PRIV_FLAT_H

/*------------------------------------------------------------------------------
 *                        Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

#include "kmclipm_vector.h"

extern double slit_tol;

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

cpl_image*          kmo_create_bad_pix_flat_thresh(
                                const cpl_image* data,
                                int surrounding_pixels,
                                int badpix_thresh);

int                 kmo_find_first_non_rejected(
                                const kmclipm_vector *vec,
                                int from_left);

int                 kmo_validate_nr_edges(
                                int nr_edges,
                                int cut_left,
                                int cut_right);

kmclipm_vector*     kmo_analize_slitedges(
                                const kmclipm_vector *midline,
                                double thresh_estimate,
                                kmclipm_vector **t_value,
                                kmclipm_vector **t_level,
                                int *t_pos);

kmclipm_vector*     kmo_analize_slitedges_advanced(
                                kmclipm_vector *midline,
                                double thresh_estimate,
                                int *cut_first,
                                int *cut_last);

cpl_array**         kmo_analize_ifu_edges(
                                kmclipm_vector *pos,
                                cpl_array *ifu_inactive,
                                int cut_first,
                                int cut_last,
                                int nx);

cpl_array**         kmo_accept_all_ifu_edges(
                                kmclipm_vector *pos,
                                cpl_array *ifu_inactive);

cpl_error_code kmo_get_slit_gap(const cpl_vector *pos,
                                cpl_vector **slits,
                                cpl_vector **gaps);

cpl_array**         kmo_analyze_flat(
                                const cpl_image* data,
                                const cpl_image* badpix,
                                cpl_array *ifu_inactive);

cpl_error_code      kmo_calc_edgepars(
                                const cpl_image *combined_data,
                                cpl_array *ifu_inactive,
                                const cpl_image *badpixel_mask,
                                const int detector_nr,
                                cpl_vector ***slitlet_ids,
                                cpl_matrix ***edgepars);

cpl_error_code      kmo_calc_curvature(
                                cpl_image *combined_data_on,
                                cpl_image *combined_noise_on,
                                cpl_array *ifu_inactive,
                                cpl_image *badpixel_mask,
                                const int detector_nr,
                                cpl_image **xcal,
                                cpl_image **ycal,
                                double *gapmean,
                                double *gapsdv,
                                double *gapmaxdev,
                                double *slitmean,
                                double *slitsdv,
                                double *slitmaxdev,
                                cpl_table ***edgepars);

cpl_vector*         kmo_polyfit_edge(
                                const kmclipm_vector *x,
                                const kmclipm_vector *y,
                                int fit_order);

cpl_error_code      kmo_edge_trace(
                                const cpl_image* data,
                                const cpl_vector* yrow,
                                cpl_vector** edge,
                                int pos,
                                int side);

cpl_error_code      kmo_calc_calib_frames(
                                cpl_vector **slitlet_ids,
                                cpl_matrix  **edgepars,
                                const int detector_nr,
                                cpl_image *data,
                                cpl_image *noise,
                                cpl_image *bad_pix,
                                cpl_image *xcal,
                                cpl_image *ycal);

cpl_error_code kmo_normalize_slitlet(
                                cpl_vector *data,
                                int start_index,
                                int end_index);

cpl_error_code      kmo_curvature_qc(
                                cpl_matrix  **edgepars,
                                double *gapmean,
                                double *gapsdv,
                                double *gapmaxdev,
                                double *slitmean,
                                double *slitsdv,
                                double *slitmaxdev);

cpl_table**         kmo_edgepars_to_table(
                                cpl_vector **slitlet_ids,
                                cpl_matrix **edgepars);


cpl_error_code      kmo_flat_interpolate_edge_parameters(
                                cpl_matrix **edgepars,
                                double threshold_factor,
                                int use_chebyshev,
                                int if_then_all_pars,
                                int left_right_pairs);

cpl_error_code      kmo_chebyshev_coefficients(
                                double *in,
                                double *out,
                                int nr_coeffs,
                                int direction);

int*                kmo_split_frame(
                                const cpl_image *xcal);

kmclipm_vector*     kmo_get_slitedges(
                                const kmclipm_vector *midline,
                                double threshold);

kmclipm_vector*     kmo_create_line_profile(
                                const cpl_image* data,
                                int lo,
                                int hi);

int                 kmo_imagelist_get_saturated(
                                const cpl_imagelist *data,
                                float threshold,
                                int sat_min);

#endif
