/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.Variable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.QNameValue;

public class IndependentContext
implements StaticContext,
NamespaceResolver,
Serializable {
    private NamePool namePool;
    private HashMap namespaces = new HashMap(10);
    private CollationMap collations;
    private IntHashMap variables = new IntHashMap(20);
    private SlotManager stackFrameMap;
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private FunctionLibrary functionLibrary;
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private NamespaceResolver externalResolver = null;
    private Set importedSchemaNamespaces = Collections.EMPTY_SET;
    private short defaultElementNamespaceCode = 0;

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.stackFrameMap = configuration.makeSlotManager();
        this.collations = new CollationMap(configuration);
        this.clearNamespaces();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        if (configuration.isAllowExternalFunctions()) {
            functionLibraryList.addFunctionLibrary(configuration.getExtensionBinder());
        }
        this.functionLibrary = functionLibraryList;
    }

    public IndependentContext copy() {
        IndependentContext independentContext = new IndependentContext(this.config);
        independentContext.namespaces = new HashMap(this.namespaces);
        independentContext.collations = new CollationMap(this.collations);
        independentContext.variables = new IntHashMap(10);
        independentContext.baseURI = this.baseURI;
        independentContext.locationMap = this.locationMap;
        independentContext.functionLibrary = this.functionLibrary;
        independentContext.defaultFunctionNamespace = this.defaultFunctionNamespace;
        independentContext.importedSchemaNamespaces = this.importedSchemaNamespaces;
        independentContext.externalResolver = this.externalResolver;
        independentContext.defaultElementNamespaceCode = this.defaultElementNamespaceCode;
        return independentContext;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.collations);
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(string)) {
            this.defaultElementNamespaceCode = (short)(this.namePool.allocateNamespaceCode(string, string2) & 0xFFFF);
        } else {
            this.namespaces.put(string, string2);
            this.namePool.allocateNamespaceCode(string, string2);
        }
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xdt", "http://www.w3.org/2005/xpath-datatypes");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        int n = nodeInfo.getNodeKind();
        if (n == 2 || n == 3 || n == 8 || n == 7 || n == 13) {
            nodeInfo = nodeInfo.getParent();
        }
        if (nodeInfo == null) {
            return;
        }
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo2.getLocalPart();
            if ("".equals(string)) {
                this.setDefaultElementNamespace(nodeInfo2.getStringValue());
                continue;
            }
            this.declareNamespace(nodeInfo2.getLocalPart(), nodeInfo2.getStringValue());
        }
        return;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.externalResolver = namespaceResolver;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void declareCollation(String string, Comparator comparator, boolean bl) {
        this.collations.setNamedCollation(string, comparator);
        if (bl) {
            this.collations.setDefaultCollationName(string);
        }
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Variable declareVariable(QNameValue qNameValue) {
        Variable variable = Variable.make(qNameValue, this.getConfiguration());
        variable.setXPathValue(null);
        int n = qNameValue.allocateNameCode(this.getNamePool()) & 0xFFFFF;
        this.variables.put(n, variable);
        int n2 = this.stackFrameMap.allocateSlotNumber(n);
        variable.setSlotNumber(n2);
        return variable;
    }

    public Variable declareVariable(String string) throws XPathException {
        String string2;
        String string3;
        Object object;
        NameChecker nameChecker = this.getConfiguration().getNameChecker();
        try {
            object = nameChecker.getQNameParts(string);
            string3 = object[0];
            string2 = object[1];
        }
        catch (QNameException qNameException) {
            throw new StaticError("Invalid QName for variable: " + string);
        }
        object = "";
        if (!"".equals(string3)) {
            object = this.getURIForPrefix(string3);
        }
        QNameValue qNameValue = new QNameValue(string3, (String)object, string2, nameChecker);
        Variable variable = Variable.make(qNameValue, this.getConfiguration());
        int n = this.namePool.allocate(string3, (String)object, string2) & 0xFFFFF;
        this.variables.put(n, variable);
        int n2 = this.stackFrameMap.allocateSlotNumber(n);
        variable.setSlotNumber(n2);
        return variable;
    }

    public int getSlotNumber(QNameValue qNameValue) {
        int n = qNameValue.allocateNameCode(this.getNamePool()) & 0xFFFFF;
        Variable variable = (Variable)this.variables.get(n);
        if (variable == null) {
            return -1;
        }
        return variable.getLocalSlotNumber();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string, false);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(string, bl);
        }
        if (string.equals("") && !bl) {
            if (bl) {
                return this.namePool.getURIFromURICode(this.defaultElementNamespaceCode);
            }
            return "";
        }
        return (String)this.namespaces.get(string);
    }

    public Iterator iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    public VariableReference bindVariable(int n) throws StaticError {
        Variable variable = (Variable)this.variables.get(n);
        if (variable == null) {
            throw new StaticError("Undeclared variable in a standalone expression");
        }
        return new VariableReference(variable);
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public Comparator getCollation(String string) {
        return this.collations.getNamedCollation(string);
    }

    public String getDefaultCollationName() {
        return this.collations.getDefaultCollationName();
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespaceCode;
    }

    public void setDefaultElementNamespace(String string) {
        int n = this.namePool.allocateNamespaceCode("", string);
        this.defaultElementNamespaceCode = (short)(n & 0xFFFF);
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isImportedSchema(String string) {
        return this.importedSchemaNamespaces.contains(string);
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        return true;
    }

    public Set getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set set) {
        this.importedSchemaNamespaces = set;
    }
}

