/* SPDX-License-Identifier: GPL-2.0-only */

#include <soc/acpi_asl.h>

/*
 * Uncore devices PCI interrupt routing packages.
 *
 * Note: The PCH routing PR00 and AR00 are defined in pch_irq.asl
 *
 * See ACPI spec 6.2.13 _PRT (PCI routing table) for details.
 * The mapping fields ae Address, Pin, Source, Source Index.
 */

// Socket 0, IIOStack 1 device legacy interrupt routing
Name (PR10, Package ()
{
	// PCI Express Port 1A-1D
	GEN_PCIE_LEGACY_IRQ(),

	// Uncore CHAUTIL Devices
	GEN_UNCORE_LEGACY_IRQ(0x0008FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0009FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000AFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000BFFFF),

	// Uncore CHASAD Devices
	GEN_UNCORE_LEGACY_IRQ(0x000EFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000FFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0010FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0011FFFF),

	// Uncore CMSCHA Devices
	GEN_UNCORE_LEGACY_IRQ(0x0014FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0015FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF),

	// Uncore CHASADALL Device
	GEN_UNCORE_LEGACY_IRQ(0x001DFFFF),

	// Uncore PCUCR Device
	GEN_UNCORE_LEGACY_IRQ(0x001EFFFF),

	// Uncore VCUCR Device
	GEN_UNCORE_LEGACY_IRQ(0x001FFFFF)
})

// Socket 0, IIOStack 1 device IOAPIC interrupt routing
Name (AR10, Package ()
{
	// PCI Express Port A-D
	GEN_PCIE_IOAPIC_IRQ(0x27,0x21,0x22,0x23),

	// Uncore CHAUTIL Devices
	GEN_UNCORE_IOAPIC_IRQ(0x0008FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0009FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x000AFFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x000BFFFF, 0x20, 0x24, 0x25, 0x26),

	// Uncore CHASAD Devices
	GEN_UNCORE_IOAPIC_IRQ(0x000EFFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x000FFFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0010FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0011FFFF, 0x20, 0x24, 0x25, 0x26),

	// Uncore CMSCHA Devices
	GEN_UNCORE_IOAPIC_IRQ(0x0014FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0015FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x20, 0x24, 0x25, 0x26),
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x20, 0x24, 0x25, 0x26),

	// Uncore CHASADALL Device
	GEN_UNCORE_IOAPIC_IRQ(0x001DFFFF, 0x20, 0x24, 0x25, 0x26),

	// Uncore PCUCR Device
	GEN_UNCORE_IOAPIC_IRQ(0x001EFFFF, 0x20, 0x24, 0x25, 0x26),

	// Uncore VCUCR Device
	GEN_UNCORE_IOAPIC_IRQ(0x001FFFFF, 0x20, 0x24, 0x25, 0x26)
})

// Socket 0, IIOStack 2 device legacy interrupt routing
Name (PR20, Package ()
{
	// PCI Express Port A-D on PC02
	GEN_PCIE_LEGACY_IRQ(),

	// Uncore M2MEM Devices
	GEN_UNCORE_LEGACY_IRQ(0x0008FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0009FFFF),

	// Uncore MCMAIN Device
	GEN_UNCORE_LEGACY_IRQ(0x000AFFFF),

	// Uncore MCDECS2 Device
	GEN_UNCORE_LEGACY_IRQ(0x000BFFFF),

	// Uncore MCMAIN Device
	GEN_UNCORE_LEGACY_IRQ(0x000CFFFF),

	// Uncore MCDECS Device
	GEN_UNCORE_LEGACY_IRQ(0x000DFFFF),

	// Uncore Unicast MC0 DDRIO0 Device
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),

	// Uncore Unicast MC1 DDRIO0 Device
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF)
})

// Socket 0, IIOStack 2 device IOAPIC interrupt routing
Name (AR20, Package ()
{
	// PCI Express Port A-D on PC02
	GEN_PCIE_IOAPIC_IRQ(0x2F,0x29,0x2A,0x2B),

	// Uncore M2MEM Devices
	GEN_UNCORE_IOAPIC_IRQ(0x0008FFFF, 0x28, 0x2C, 0x2D, 0x2E),
	GEN_UNCORE_IOAPIC_IRQ(0x0009FFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore MCMAIN Device
	GEN_UNCORE_IOAPIC_IRQ(0x000AFFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore MCDECS2 Device
	GEN_UNCORE_IOAPIC_IRQ(0x000BFFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore MCMAIN Device
	GEN_UNCORE_IOAPIC_IRQ(0x000CFFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore MCDECS Device
	GEN_UNCORE_IOAPIC_IRQ(0x000DFFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore Unicast MC0 DDRIO0 Device
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x28, 0x2C, 0x2D, 0x2E),

	// Uncore Unicast MC1 DDRIO0 Device
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x28, 0x2C, 0x2D, 0x2E)
})

// Socket 0, IIOStack 3 device legacy interrupt routing
Name (PR28, Package ()
{
	// PCI Express Port 3 on PC03
	GEN_PCIE_LEGACY_IRQ(),

	// KTI Devices
	GEN_UNCORE_LEGACY_IRQ(0x000EFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000FFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0010FFFF),

	// M3K Device
	GEN_UNCORE_LEGACY_IRQ(0x0012FFFF),

	// M2U Device
	GEN_UNCORE_LEGACY_IRQ(0x0015FFFF),

	// M2D Device
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),

	// M20 Device
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF)
})

// Socket 0, IIOStack 3 device IOAPIC interrupt routing
Name (AR28, Package ()
{
	// PCI Express Port 3 A-D on PC03
	GEN_PCIE_IOAPIC_IRQ(0x37,0x31,0x32,0x33),

	// KTI Devices
	GEN_UNCORE_IOAPIC_IRQ(0x000EFFFF, 0x30, 0x34, 0x35, 0x36),
	GEN_UNCORE_IOAPIC_IRQ(0x000FFFFF, 0x30, 0x34, 0x35, 0x36),
	GEN_UNCORE_IOAPIC_IRQ(0x0010FFFF, 0x30, 0x34, 0x35, 0x36),

	// M3K Device
	GEN_UNCORE_IOAPIC_IRQ(0x0012FFFF, 0x30, 0x34, 0x35, 0x36),

	// M2U Device
	GEN_UNCORE_IOAPIC_IRQ(0x0015FFFF, 0x30, 0x34, 0x35, 0x36),

	// M2D Device
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x30, 0x34, 0x35, 0x36),

	// M20 Device
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x30, 0x34, 0x35, 0x36)
})

// Socket 1, IIOStack 0 device legacy interrupt routing
Name (PR40, Package ()
{
	// DMI
	Package () { 0x0000FFFF, 0x00, LNKA, 0x00 },

	// CBDMA
	GEN_UNCORE_LEGACY_IRQ(0x0004FFFF),

	// Ubox
	GEN_UNCORE_LEGACY_IRQ(0x0008FFFF)
})

// Socket 1, IIOStack 0 device IOAPIC interrupt routing
Name (AR40, Package ()
{
	// DMI
	Package () { 0x0000FFFF, 0x00, 0x00, 0x4F },

	// CBDMA
	GEN_UNCORE_IOAPIC_IRQ(0x0004FFFF, 0x4A, 0x4B, 0x4A, 0x4B),

	// Ubox
	GEN_UNCORE_IOAPIC_IRQ(0x0008FFFF, 0x48, 0x4C, 0x4D, 0x4E),
})

// Socket 1, IIOStack 1 device legacy interrupt routing
Name (PR50, Package ()
{
	// PCI Express Port
	GEN_PCIE_LEGACY_IRQ(),

	// CHA Devices
	GEN_UNCORE_LEGACY_IRQ(0x0008FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0009FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000AFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000BFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000EFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000FFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0010FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0011FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0014FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0015FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x001DFFFF),

	// PCU Devices
	GEN_UNCORE_LEGACY_IRQ(0x001EFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x001FFFFF)
})

// Socket 1, IIOStack 1 device IOAPIC interrupt routing
Name (AR50, Package ()
{
	// PCI Express Port A-D
	GEN_PCIE_IOAPIC_IRQ(0x57,0x51,0x52,0x53),

	// CHA Devices
	GEN_UNCORE_IOAPIC_IRQ(0x0008FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0009FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x000AFFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x000BFFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x000EFFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x000FFFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0010FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0011FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0014FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0015FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x001DFFFF, 0x50, 0x54, 0x55, 0x56),

	// PCU Devices
	GEN_UNCORE_IOAPIC_IRQ(0x001EFFFF, 0x50, 0x54, 0x55, 0x56),
	GEN_UNCORE_IOAPIC_IRQ(0x001FFFFF, 0x50, 0x54, 0x55, 0x56)
})

// Socket 1, IIOStack 2 device legacy interrupt routing
Name (PR60, Package ()
{
	// PCI Express Port
	GEN_PCIE_LEGACY_IRQ(),

	// Integrated Memory Controller
	GEN_UNCORE_LEGACY_IRQ(0x0008FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0009FFFF),

	// Uncore Devices
	GEN_UNCORE_LEGACY_IRQ(0x000AFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000BFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000CFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000DFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF)
})

// Socket 1, IIOStack 2 device IOAPIC interrupt routing
Name (AR60, Package ()
{
	// PCI Express Port A-D
	GEN_PCIE_IOAPIC_IRQ(0x5F,0x59,0x5A,0x5B),

	// Integrated Memory Controller
	GEN_UNCORE_IOAPIC_IRQ(0x0008FFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x0009FFFF, 0x58, 0x5C, 0x5D, 0x5E),

	// Uncore Devices
	GEN_UNCORE_IOAPIC_IRQ(0x000AFFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x000BFFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x000CFFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x000DFFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x58, 0x5C, 0x5D, 0x5E),
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x58, 0x5C, 0x5D, 0x5E)
})

// Socket 1, IIOStack 3 device legacy interrupt routing
Name (PR68, Package ()
{
	// PCI Express Port
	GEN_PCIE_LEGACY_IRQ(),

	// Uncore Devices
	GEN_UNCORE_LEGACY_IRQ(0x000EFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x000FFFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0010FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0012FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0015FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0016FFFF),
	GEN_UNCORE_LEGACY_IRQ(0x0017FFFF)
})

// Socket 1, IIOStack 3 device legacy interrupt routing
Name (AR68, Package ()
{
	// PCI Express Port A-D
	GEN_PCIE_IOAPIC_IRQ(0x67,0x61,0x62,0x63),

	// Uncore Devices
	GEN_UNCORE_IOAPIC_IRQ(0x000EFFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x000FFFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x0010FFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x0012FFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x0015FFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x0016FFFF, 0x60, 0x64, 0x65, 0x66),
	GEN_UNCORE_IOAPIC_IRQ(0x0017FFFF, 0x60, 0x64, 0x65, 0x66)
})
