---
id: Filters
section: patterns
---

import { Fragment, useEffect, useRef, useState } from 'react';
import {
Popper,
SearchInput,
Toolbar,
ToolbarContent,
ToolbarItem,
Menu,
MenuContent,
MenuList,
MenuItem,
MenuToggle,
MenuToggleCheckbox,
ToolbarGroup,
ToolbarFilter,
Badge,
Pagination,
EmptyState,
EmptyStateBody,
EmptyStateFooter,
EmptyStateActions,
Title,
Button,
Bullseye,
ToolbarToggleGroup
} from '@patternfly/react-core';
import FilterIcon from '@patternfly/react-icons/dist/esm/icons/filter-icon';
import SearchIcon from '@patternfly/react-icons/dist/esm/icons/search-icon';
import { Table, Thead, Tr, Th, Tbody, Td } from '@patternfly/react-table';

## Filtering demos

### Search input

```ts file="./examples/FilterSearchInput.tsx"

```

### Single select

```ts file="./examples/FilterSingleSelect.tsx"

```

### Checkbox select

```ts file="./examples/FilterCheckboxSelect.tsx"

```

### Attribute search

```ts file="./examples/FilterAttributeSearch.tsx"

```

### Mixed select filter group

```ts file="./examples/FilterMixedSelectGroup.tsx"

```

### Single select filter group

```ts file="./examples/FilterSameSelectGroup.tsx"

```

### Faceted filter

```ts file="./examples/FilterFaceted.tsx"

```
