/*
 * execute.h
 *
 * Copyright (C) 2004 Bastian Blank <waldi@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $LastChangedBy: bastian $
 * $LastChangedDate: 2004-09-19 12:03:45 +0200 (Sun, 19 Sep 2004) $
 * $LastChangedRevision: 628 $
 */

#ifndef EXECUTE_H
#define EXECUTE_H

#include <debian-installer.h>

extern const char *const execute_environment_target[];

typedef int execute_io_handler (char *buf, size_t len, void *user_data);
int execute_io_log_handler (char *buf, size_t n, void *user_data);

int execute_full (const char *const command, execute_io_handler *stdout_handler, execute_io_handler *stderr_handler, void *io_user_data);
int execute_target_full (const char *const command, execute_io_handler *stdout_handler, execute_io_handler *stderr_handler, void *io_user_data);

inline static int execute (const char *const command)
{
  return execute_full (command, execute_io_log_handler, execute_io_log_handler, NULL);
}

inline static int execute_target (const char *command)
{ 
  return execute_target_full (command, execute_io_log_handler, execute_io_log_handler, NULL);
}

#endif
