/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef  _ContFrame_H_
#define  _ContFrame_H_

#ifdef HAS_WINDOWS

#include <string>

#include <GraphTool.H>


//
//@Man:
//@Doc: Handles a single contour frame, and has the interface to GraphTool
//@Memo: Handles a single contour frame
class ContFrame {

public:
    friend class Contour;
    friend std::ostream& operator << (std::ostream &os, Contour &cont);

//@ManDoc: Constructor
    ContFrame(std::string nm, std::string varname, int dev, int freq,
	      int ncont, int sz=400);
      
//@ManDoc: Destructor
    ~ContFrame();
      
private:
//@ManDoc: Root name of the PostScript file for this variable
    std::string    name;        
//@ManDoc: Which device (Screen display, PostScript file, or both)
    GTDevice   device;      
//@ManDoc: Name of the variable to be contoured
    std::string    variable;  
//@ManDoc: Frequency of plotting
    int        interval; 
//@ManDoc: Number of contour lines per plot
    int        num_cont; 
//@ManDoc: Number of pixels in the window
    int        size;	
//@ManDoc: If true, draw the grids also
    int        draw_mesh; 
//@ManDoc: Next frame in list 
    ContFrame *next;     
//@ManDoc: The window to be drawn in
    GraphTool  *win;    
};

#endif
#endif
