/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"

#define DIMS lo_1,lo_2,lo_3,hi_1,hi_2,hi_3

c *************************************************************************
c ** SCALUPD **
c ** Update the scalars using conservative or convective differencing of fluxes
c *************************************************************************

      subroutine scalupd(s,sn,sedgex,sedgey,sedgez,uadv,vadv,wadv,diff,force,
     $                   areax,areay,areaz,vol,DIMS,dx,dt,is_conserv,numscal)

      implicit none

      integer DIMS
      integer numscal
      REAL_T       s(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3,numscal)
      REAL_T      sn(lo_1-3:hi_1+3,lo_2-3:hi_2+3,lo_3-3:hi_3+3,numscal)
      REAL_T  sedgex(lo_1  :hi_1+1,lo_2  :hi_2  ,lo_3  :hi_3  ,numscal)
      REAL_T  sedgey(lo_1  :hi_1  ,lo_2  :hi_2+1,lo_3  :hi_3  ,numscal)
      REAL_T  sedgez(lo_1  :hi_1  ,lo_2  :hi_2  ,lo_3  :hi_3+1,numscal)
      REAL_T    uadv(lo_1  :hi_1+1,lo_2  :hi_2  ,lo_3  :hi_3  )
      REAL_T    vadv(lo_1  :hi_1  ,lo_2  :hi_2+1,lo_3  :hi_3  )
      REAL_T    wadv(lo_1  :hi_1  ,lo_2  :hi_2  ,lo_3  :hi_3+1)
      REAL_T    diff(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1,numscal)
      REAL_T   force(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1,numscal)
      REAL_T   areax(lo_1  :hi_1+1,lo_2  :hi_2  ,lo_3  :hi_3  )
      REAL_T   areay(lo_1  :hi_1  ,lo_2  :hi_2+1,lo_3  :hi_3  )
      REAL_T   areaz(lo_1  :hi_1  ,lo_2  :hi_2  ,lo_3  :hi_3+1)
      REAL_T     vol(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1)
      REAL_T dx(3)
      REAL_T dt
      integer is_conserv(numscal)

c     Local variables
      REAL_T  divsu
      REAL_T  uconv
      REAL_T  vconv
      REAL_T  wconv
      integer i,j,k,n

      do n = 1, numscal

      if (is_conserv(n) .eq. 1) then

        do k = lo_3,hi_3
        do j = lo_2,hi_2
        do i = lo_1,hi_1
          divsu = ( sedgex(i+1,j,k,n)*uadv(i+1,j,k)*areax(i+1,j,k) -
     $              sedgex(i  ,j,k,n)*uadv(i  ,j,k)*areax(i  ,j,k) + 
     $              sedgey(i,j+1,k,n)*vadv(i,j+1,k)*areay(i,j+1,k) - 
     $              sedgey(i,j  ,k,n)*vadv(i,j  ,k)*areay(i,j  ,k) +
     $              sedgez(i,j,k+1,n)*wadv(i,j,k+1)*areaz(i,j,k+1) - 
     $              sedgez(i,j,k  ,n)*wadv(i,j,k  )*areaz(i,j,k  ) ) / vol(i,j,k) 

          sn(i,j,k,n) = s(i,j,k,n) - dt*divsu + half*dt*diff(i,j,k,n)+dt*force(i,j,k,n)

        enddo
        enddo
        enddo
 
      else 

        do k = lo_3,hi_3
        do j = lo_2,hi_2
        do i = lo_1,hi_1

          uconv = half * (uadv(i+1,j,k) + uadv(i,j,k))
          vconv = half * (vadv(i,j+1,k) + vadv(i,j,k))
          wconv = half * (wadv(i,j,k+1) + wadv(i,j,k))

          divsu = uconv * (sedgex(i+1,j,k,n) - sedgex(i,j,k,n)) / dx(1) +
     $            vconv * (sedgey(i,j+1,k,n) - sedgey(i,j,k,n)) / dx(2) + 
     $            wconv * (sedgez(i,j,k+1,n) - sedgez(i,j,k,n)) / dx(3) 

          sn(i,j,k,n) = s(i,j,k,n) - dt*divsu + half*dt*diff(i,j,k,n) + dt*force(i,j,k,n)

        enddo
        enddo
        enddo

      endif

      enddo

      return
      end
