/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _INTELHEX_H
#define _INTELHEX_H

#include <stdio.h>

/*
 defining type 'inteldata':
  offset is the address offset
  datalen is the actual number of elements in data
  file is a pointer to the file/stream
  eof_found is set to 1 when :00000001FF if found (endoffile)
  */
typedef struct {
    unsigned char recdata[256];
    unsigned int offset;
    unsigned int reclen;
    FILE * file;
    int eof_found;
} inteldata;

int intelhex_fileopen (inteldata *id, char *filename, int mode);

int intelhex_fileclose (inteldata *id);

/* intelhex_readline returns:
 1  = successfull read - data available
 0  = successfull read - eof_record found
      or did't read because eof_record had already been found
 >1 = unsuccessfull read, error sent to stdout
*/
int intelhex_readline (inteldata *id);

/* put data in inteldata->recdata
   put datalength in inteldata->reclen
   put load offset in inteldata->offset
   then execute intelhex_writeline instruction
*/
int intelhex_writeline (inteldata *id);

/* writes an eof record in the file */
void intelhex_writeeof (inteldata *id);

#endif
