///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) Crossbar.io Technologies GmbH and contributors
//
// Boost Software License - Version 1.0 - August 17th, 2003
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
///////////////////////////////////////////////////////////////////////////////

#include <msgpack.hpp>
#include <string>
#include <unordered_map>

namespace autobahn {

inline wamp_call_options::wamp_call_options()
    : m_timeout()
{
}

inline const std::chrono::milliseconds& wamp_call_options::timeout() const
{
    return m_timeout;
}

inline void wamp_call_options::set_timeout(const std::chrono::milliseconds& timeout)
{
    m_timeout = timeout;
}

} // namespace autobahn

namespace msgpack {
MSGPACK_API_VERSION_NAMESPACE(MSGPACK_DEFAULT_API_NS) {
namespace adaptor {

template<>
struct convert<autobahn::wamp_call_options>
{
    msgpack::object const& operator()(
            msgpack::object const& object,
            autobahn::wamp_call_options& options) const
    {
        std::unordered_map<std::string, msgpack::object> options_map;
        object >> options_map;

        const auto options_map_itr = options_map.find("timeout");
        if (options_map_itr != options_map.end()) {
            options.set_timeout(std::chrono::milliseconds(options_map_itr->second.as<unsigned>()));
        }

        return object;
    }
};

template<>
struct pack<autobahn::wamp_call_options>
{
    template <typename Stream>
    msgpack::packer<Stream>& operator()(
            msgpack::packer<Stream>& packer,
            autobahn::wamp_call_options const& options) const
    {
        std::unordered_map<std::string, unsigned> options_map;
        const auto& timeout = options.timeout();
        if (timeout.count() > 0) {
            options_map["timeout"] = timeout.count();
        }

        packer.pack(options_map);

        return packer;
    }
};

template <>
struct object_with_zone<autobahn::wamp_call_options>
{
    void operator()(
            msgpack::object::with_zone& object,
            const autobahn::wamp_call_options& options)
    {
        std::unordered_map<std::string, msgpack::object> options_map;

        const auto& timeout = options.timeout();
        if (timeout.count() != 0) {
            options_map["timeout"] = msgpack::object(timeout.count());
        }

        object << options_map;
    }
};

} // namespace adaptor
} // MSGPACK_API_VERSION_NAMESPACE(MSGPACK_DEFAULT_API_NS)
} // namespace msgpack
