/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.instrument.Archive;
import net.sourceforge.cobertura.instrument.ClassPattern;
import net.sourceforge.cobertura.instrument.CoberturaFile;
import net.sourceforge.cobertura.instrument.CoberturaInstrumenter;
import net.sourceforge.cobertura.util.ArchiveUtil;
import net.sourceforge.cobertura.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeInstrumentationTask {
    private static final LoggerWrapper logger = new LoggerWrapper();
    private CoberturaInstrumenter coberturaInstrumenter;
    private File destinationDirectory;
    private ClassPattern classPattern;

    public CodeInstrumentationTask instrument(Arguments arguments, ProjectData projectData) throws Throwable {
        this.destinationDirectory = arguments.getDestinationDirectory();
        this.classPattern = new ClassPattern();
        this.coberturaInstrumenter = new CoberturaInstrumenter();
        this.coberturaInstrumenter.setIgnoreRegexes(arguments.getIgnoreRegexes());
        Set<CoberturaFile> filePaths = arguments.getFilesToInstrument();
        File dataFile = arguments.getDataFile();
        this.destinationDirectory = arguments.getDestinationDirectory();
        this.coberturaInstrumenter.setDestinationDirectory(this.destinationDirectory);
        arguments.getIgnoreRegexes();
        this.classPattern.addExcludeClassesRegex(arguments.getClassPatternExcludeClassesRegexes());
        this.classPattern.addIncludeClassesRegex(arguments.getClassPatternIncludeClassesRegexes());
        this.coberturaInstrumenter.setIgnoreTrivial(arguments.isIgnoreTrivial());
        this.coberturaInstrumenter.setIgnoreMethodAnnotations(arguments.getIgnoreMethodAnnotations());
        this.coberturaInstrumenter.setIgnoreClassAnnotations(arguments.getIgnoreClassAnnotations());
        this.coberturaInstrumenter.setThreadsafeRigorous(arguments.isThreadsafeRigorous());
        this.coberturaInstrumenter.setFailOnError(arguments.isFailOnError());
        this.coberturaInstrumenter.setProjectData(projectData);
        logger.info(String.format("Instrumenting %s %s %s", filePaths.size(), filePaths.size() == 1 ? "file" : "files", this.destinationDirectory != null ? " to " + this.destinationDirectory.getAbsoluteFile() : ""));
        for (CoberturaFile coberturaFile : filePaths) {
            if (coberturaFile.isArchive()) {
                this.addInstrumentationToArchive(coberturaFile);
                continue;
            }
            this.addInstrumentation(coberturaFile);
        }
        CoverageDataFileHandler.saveCoverageData(projectData, dataFile);
        return this;
    }

    private static boolean isClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInstrumentationToArchive(CoberturaFile file, InputStream archive, OutputStream output) throws Exception {
        boolean bl;
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream(archive);
            zos = new ZipOutputStream(output);
            bl = this.addInstrumentationToArchive(file, zis, zos);
        }
        catch (Throwable throwable) {
            zis = (ZipInputStream)IOUtil.closeInputStream(zis);
            zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
            throw throwable;
        }
        zis = (ZipInputStream)IOUtil.closeInputStream(zis);
        zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
        return bl;
    }

    private boolean addInstrumentationToArchive(CoberturaFile file, ZipInputStream archive, ZipOutputStream output) throws Exception {
        ZipEntry entry;
        boolean modified = false;
        while ((entry = archive.getNextEntry()) != null) {
            try {
                String entryName = entry.getName();
                if (ArchiveUtil.isSignatureFile(entry.getName())) continue;
                ZipEntry outputEntry = new ZipEntry(entry.getName());
                outputEntry.setComment(entry.getComment());
                outputEntry.setExtra(entry.getExtra());
                outputEntry.setTime(entry.getTime());
                output.putNextEntry(outputEntry);
                byte[] entryBytes = IOUtil.createByteArrayFromInputStream(archive);
                if (this.classPattern.isSpecified() && ArchiveUtil.isArchive(entryName)) {
                    Archive archiveObj = new Archive(file, entryBytes);
                    this.addInstrumentationToArchive(archiveObj);
                    if (archiveObj.isModified()) {
                        modified = true;
                        entryBytes = archiveObj.getBytes();
                        outputEntry.setTime(System.currentTimeMillis());
                    }
                } else if (CodeInstrumentationTask.isClass(entry) && this.classPattern.matches(entryName)) {
                    try {
                        CoberturaInstrumenter.InstrumentationResult res = this.coberturaInstrumenter.instrumentClass(new ByteArrayInputStream(entryBytes));
                        if (res != null) {
                            logger.debug("Putting instrumented entry: " + entry.getName());
                            entryBytes = res.getContent();
                            modified = true;
                            outputEntry.setTime(System.currentTimeMillis());
                        }
                    }
                    catch (Throwable t) {
                        if (entry.getName().endsWith("_Stub.class")) {
                            logger.debug("Problems instrumenting archive entry: " + entry.getName(), t);
                        }
                        logger.warn("Problems instrumenting archive entry: " + entry.getName(), t);
                    }
                }
                output.write(entryBytes);
                output.closeEntry();
                archive.closeEntry();
            }
            catch (Exception e) {
                logger.warn("Problems with archive entry: " + entry.getName(), e);
            }
            catch (Throwable t) {
                logger.warn("Problems with archive entry: " + entry.getName(), t);
            }
            output.flush();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentationToArchive(Archive archive) throws Exception {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = archive.getInputStream();
            out = new ByteArrayOutputStream();
            boolean modified = this.addInstrumentationToArchive(archive.getCoberturaFile(), in, out);
            if (modified) {
                out.flush();
                byte[] bytes = out.toByteArray();
                archive.setModifiedBytes(bytes);
            }
        }
        finally {
            in = IOUtil.closeInputStream(in);
            out = (ByteArrayOutputStream)IOUtil.closeOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentationToArchive(CoberturaFile archive) {
        logger.debug("Instrumenting archive " + archive.getAbsolutePath());
        File outputFile = null;
        ZipInputStream input = null;
        ZipOutputStream output = null;
        boolean modified = false;
        try {
            try {
                input = new ZipInputStream(new FileInputStream(archive));
            }
            catch (FileNotFoundException e) {
                logger.warn("Cannot open archive file: " + archive.getAbsolutePath(), e);
                input = (ZipInputStream)IOUtil.closeInputStream(input);
                output = (ZipOutputStream)IOUtil.closeOutputStream(output);
                return;
            }
        }
        catch (Throwable throwable) {
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            throw throwable;
        }
        try {
            if (this.destinationDirectory != null) {
                outputFile = new File(this.destinationDirectory, archive.getPathname());
            } else {
                outputFile = File.createTempFile("CoberturaInstrumentedArchive", "jar");
                outputFile.deleteOnExit();
            }
            output = new ZipOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            logger.warn("Cannot open file for instrumented archive: " + archive.getAbsolutePath(), e);
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            return;
        }
        try {
            modified = this.addInstrumentationToArchive(archive, input, output);
        }
        catch (Throwable e) {
            logger.warn("Cannot instrument archive: " + archive.getAbsolutePath(), e);
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            return;
        }
        input = (ZipInputStream)IOUtil.closeInputStream(input);
        output = (ZipOutputStream)IOUtil.closeOutputStream(output);
        if (modified && this.destinationDirectory == null) {
            try {
                logger.debug("Moving " + outputFile.getAbsolutePath() + " to " + archive.getAbsolutePath());
                IOUtil.moveFile(outputFile, archive);
            }
            catch (IOException e) {
                logger.warn("Cannot instrument archive: " + archive.getAbsolutePath(), e);
                return;
            }
        }
        if (this.destinationDirectory != null && !modified) {
            outputFile.delete();
        }
    }

    private void addInstrumentationToSingleClass(File file) {
        logger.info("Instrumenting: " + file.getAbsolutePath() + " to " + this.destinationDirectory);
        this.coberturaInstrumenter.addInstrumentationToSingleClass(file);
    }

    private void addInstrumentation(CoberturaFile coberturaFile) {
        if (coberturaFile.isClass() && this.classPattern.matches(coberturaFile.getPathname())) {
            this.addInstrumentationToSingleClass(coberturaFile);
        } else if (coberturaFile.isDirectory()) {
            String[] contents = coberturaFile.list();
            for (int i = 0; i < contents.length; ++i) {
                File relativeFile = new File(coberturaFile.getPathname(), contents[i]);
                CoberturaFile relativeCoberturaFile = new CoberturaFile(coberturaFile.getBaseDir(), relativeFile.toString());
                this.addInstrumentation(relativeCoberturaFile);
            }
        }
    }

    private static class LoggerWrapper {
        private final Logger logger = LoggerFactory.getLogger(LoggerWrapper.class);
        private boolean failOnError = false;

        private LoggerWrapper() {
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void debug(String message, Throwable t) {
            this.logger.debug(message, t);
        }

        public void info(String message) {
            this.logger.debug(message);
        }

        public void warn(String message, Throwable t) {
            this.logger.warn(message, t);
            if (this.failOnError) {
                throw new RuntimeException("Warning detected and failOnError is true", t);
            }
        }
    }
}

