/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgProcedure;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.io.PrintWriter;

public class PgDiffProcedures {
    public static void createProducedures(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgProcedure pgProcedure : pgSchema2.getProcedures()) {
            PgProcedure pgProcedure2 = pgSchema == null ? null : pgSchema.getProcedure(pgProcedure.getSignature());
            if (pgProcedure2 != null && pgProcedure.equals(pgProcedure2, pgDiffArguments.isIgnoreFunctionWhitespace())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgProcedure.getCreationSQL());
        }
    }

    public static void dropPocedures(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgProcedure pgProcedure : pgSchema.getProcedures()) {
            if (pgSchema2.containsProcedure(pgProcedure.getSignature())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgProcedure.getDropSQL());
        }
    }

    public static void alterComments(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgProcedure pgProcedure : pgSchema.getProcedures()) {
            boolean bl;
            PgProcedure pgProcedure2 = pgSchema2.getProcedure(pgProcedure.getSignature());
            if (pgProcedure2 == null) continue;
            if (pgProcedure.getComment() == null && pgProcedure2.getComment() != null || pgProcedure.getComment() != null && pgProcedure2.getComment() != null && !pgProcedure.getComment().equals(pgProcedure2.getComment())) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON PROCEDURE ");
                printWriter.print(PgDiffUtils.getQuotedName(pgProcedure2.getName()));
                printWriter.print('(');
                bl = false;
                for (PgProcedure.Argument argument : pgProcedure2.getArguments()) {
                    if (bl) {
                        printWriter.print(", ");
                    } else {
                        bl = true;
                    }
                    printWriter.print(argument.getDeclaration(false));
                }
                printWriter.print(") IS ");
                printWriter.print(pgProcedure2.getComment());
                printWriter.println(';');
                continue;
            }
            if (pgProcedure.getComment() == null || pgProcedure2.getComment() != null) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON PROCEDURE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgProcedure2.getName()));
            printWriter.print('(');
            bl = false;
            for (PgProcedure.Argument argument : pgProcedure2.getArguments()) {
                if (bl) {
                    printWriter.print(", ");
                } else {
                    bl = true;
                }
                printWriter.print(argument.getDeclaration(false));
            }
            printWriter.println(") IS NULL;");
        }
    }

    private PgDiffProcedures() {
    }
}

