
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_set.n,v 1.3 2003/04/10 16:16:08 shmooved Exp $
'\"
'\" 
.so man.macros

.TH ns_set n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_set \- commands
.SH SYNOPSIS
Manipulate sets of key-value pairs.
.SH SYNTAX
.PP
\fBns_set copy \fR?-persist?\fR \fIsetId \fR
.PP
\fBns_set cput \fIsetId key value\fR
.PP
\fBns_set create \fR?-persist? \fIname\fR
.PP
\fBns_set delete \fIsetId fieldNumber\fI
.PP
\fBns_set delkey \fIsetId key\fR
.PP
\fBns_set find \fIsetId key\fR
.PP
\fBns_set free \fIsetId\fR
.PP
\fBns_set get \fIsetId key\fR
.PP
\fBns_set icput \fIsetId key value\fR
.PP
\fBns_set idelkey \fIsetId key\fR
.PP
\fBns_set ifind \fIsetId key\fR
.PP
\fBns_set iget \fIsetId key\fR
.PP
\fBns_set isnull \fIsetId fieldNumber\fR
.PP
\fBns_set iunique \fIsetId key\fR
.PP
\fBns_set key \fIsetId fieldNumber\fR
.PP
\fBns_set merge \fIhigh low\fR
.PP
\fBns_set move \fIto from\fR
.PP
\fBns_set\fR \fIname setId\fR
.PP
\fBns_set new\fR ?-persist? \fIname\fR
.PP
\fBns_set print\fR \fIsetId\fR
.PP
\fBns_set put\fR \fIsetId key value\fR
.PP
\fBns_set size\fR \fIsetId\fR
.PP
\fBns_set split\fR ?-persist? \fIsetId\fR ?splitChar?
.PP
\fBns_set truncate\fR \fIsetId size\fR
.PP
\fBns_set unique\fR \fIsetId key\fR
.PP
\fBns_set update\fR \fIsetId key value\fR
.PP
\fBns_set value\fR \fIsetId fieldNumber\fR
.PP
.BE

.SH DESCRIPTION
.PP
\fBns_set copy\fR
.RS 
Returns a new set that has the same name and key value pairs as the passed-in set (setId). If -persist is specified, the new set will persist even after the current transaction ends, and you can free it later with ns_set free. If -persist is not specified, the new set is automatically freed when the transaction ends.
.RE
.PP
\fBns_set cput\fR
.RS
appends a new field to the set with key key and value value if the field does not already exist in the set. The field number of the new field is returned.
.RE
.PP
\fBns_set create\fR
.RS
(which is the same as ns_set new) allocates memory for a new set and returns the ID for the new set. If -persist is specified, the new set will persist even after the current transaction ends, and you can free it later with ns_set free. If -persist is not specified, the new set is automatically freed when the transaction ends.
.RE
.PP
\fBns_set delete\fR
.RS
deletes the field in the set at field number fieldNumber.
.RE
.PP
\fBns_set delkey\fR
.RS
removes the first field in the set whose key is key. Note that there could be multiple fields in the set with this key; this command only removes the first occurrence.
.RE
.PP
\fBns_set find\fR 
.RS
returns the index of the first field in the specified set whose key name matches the specified key. Zero (0) is the index of the first field. If no matching fields are found, ns_set find returns -1.
.RE
.PP
\fBns_set free\fR
.RS
frees the specified set. Sets must be explicitly freed with ns_set free if the -persist option was used when creating the set. Otherwise, sets are automatically freed when the transaction ends.
.RE
.PP
\fBns_set get\fR
.RS
returns the first value associated with the passed-in key. If the key is invalid, an empty string is returned.
.RE
.PP
\fBns_set icput\fR
.RS
is the case-insensitive counterpart of ns_set cput.
.RE
.PP
\fBns_set idelkey\fR 
.RS
is the case-insensitive counterpart of ns_set delkey.
.RE
.PP
\fBns_set ifind\fR 
.RS
is the case-insensitive counterpart of ns_set find.
.RE
.PP
\fBns_set iget\fR
.RS
is the case-insensitive counterpart of ns_set get.
.RE
.PP
\fBns_set isnull\fR 
.RS
returns 1 if the value of the field specified by fieldNumber is null and 0 if it is not. Note that an empty string is not the same as a null. ns_set isnull will return 0 for an empty string.
.RE
.PP
\fBns_set iunique\fR 
.RS
returns 1 if the specified key is unique in the specified set and 0 if it is not. The test for uniqueness is performed case-insensitively. ns_set unique is the case-sensitive version of this function.
.PP
For example, a client could send multiple "Accept:" headers which would end up in the header set for the connection. ns_set iunique would return 0 for the "Accept:" key, because there are multiple fields with the key "Accept:".
.RE
.PP
\fBns_set key\fR
.RS
extracts the key of the set at field number fieldNumber. This command is useful when looping through all the key-value pairs in the set.
.RE
.PP
\fBns_set merge\fR 
.RS
merges two sets. Any fields in the low set are appended to the high set if a field with the same key name does not already exist in the high set.
.RE
.PP
\fBns_set move\fR 
.RS
moves all fields from the from set to the end of the to set, leaving the from set a valid, empty set.
.RE
.PP
\fBns_set name\fR
.RS
returns the name of the set.
.RE
.PP
\fBns_set new\fR
.RS
(which is the same as ns_set create) allocates memory for a new set and returns the ID for the new set. If -persist is specified, the new set will persist even after the current transaction ends, and you can free it later with ns_set free. If -persist is not specified, the new set is automatically freed when the transaction ends.
.RE
.PP
\fBns_set print\fR
.RS
prints the specified set to stderr.
.RE
.PP
\fBns_set put\fR 
.RS
appends a new field to the set with key key and value value. Note that the field is appended so if a previous field has the same key as the new field, the previous field is returned by ns_set get command. The field number of the new field is returned.
.RE
.PP
\fBns_set size\fR
.RS
returns the number of key-value pairs in the set.
.RE
.PP
\fBns_set split\fR
.RS
splits one set into multiple sets based on the splitChar as described below and returns a Tcl list of the newly-allocated sets. It assumes that the keys in the specified set (setId) contain a specific character (splitChar) that can be used to separate the name of a new set and the key in the new set. The default splitChar is a period (.).
.PP
For example, if two fields in the original set have "dog.food" and "cat.food" as their key names and "Yummy dog food!" and "Yummy cat food!" as their values, ns_set split would return two new sets named "dog" and "cat". The dog set would have a single field whose key is "food" and whose value is "Yummy dog food!". The cat set would have a single field whose key is "food" and whose value is "Yummy cat food!".
.RE
.PP
\fBns_set truncate\fR 
.RS
reduces the set to the first size key-value pairs and frees the memory for the rest of the key-value pairs that may have been in the set.
.RE
.PP
\fBns_set unique\fR
.RS
returns 1 if the specified key is unique in the specified set and 0 if it is not. The test for uniqueness is performed case-sensitively. ns_set iunique is the case-insensitive version of this function.
.RE
.PP
\fBns_set update\fR
.RS
updates the first field in the specified set whose key is key and replaces its value with value. ns_set update is equivalent to ns_set delkey followed by ns_set put.
.RE
.PP
\fBns_set value\fR 
.RS
extracts the value of the set at field number fieldNumber. This command is useful when looping through all the key-value pairs in the set.
.RE
.SH "NOTES"
The fields in the set are ordered by number. The field numbers range from 0 to one less than the total number of fields. For example, if you have a set with 5 fields, you would use "ns_set key $setid 4" to extract the key of the last field in the set.
.PP
.SH KEYWORDS
key value 

