# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_vpn_ipsec_phase1
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_vpn_ipsec_phase1.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_vpn_ipsec_phase1_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-negotiate': 'enable',
        'banner': 'test_value_14',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_19',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '22',
        'dns-mode': 'manual',
        'domain': 'test_value_24',
        'dpd': 'disable',
        'dpd-retrycount': '26',
        'dpd-retryinterval': 'test_value_27',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'enforce-unique-id': 'disable',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '33',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_35',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '38',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_41',
        'ipv4-dns-server1': 'test_value_42',
        'ipv4-dns-server2': 'test_value_43',
        'ipv4-dns-server3': 'test_value_44',
        'ipv4-end-ip': 'test_value_45',
        'ipv4-name': 'test_value_46',
        'ipv4-netmask': 'test_value_47',
        'ipv4-split-exclude': 'test_value_48',
        'ipv4-split-include': 'test_value_49',
        'ipv4-start-ip': 'test_value_50',
        'ipv4-wins-server1': 'test_value_51',
        'ipv4-wins-server2': 'test_value_52',
        'ipv6-dns-server1': 'test_value_53',
        'ipv6-dns-server2': 'test_value_54',
        'ipv6-dns-server3': 'test_value_55',
        'ipv6-end-ip': 'test_value_56',
        'ipv6-name': 'test_value_57',
        'ipv6-prefix': '58',
        'ipv6-split-exclude': 'test_value_59',
        'ipv6-split-include': 'test_value_60',
        'ipv6-start-ip': 'test_value_61',
        'keepalive': '62',
        'keylife': '63',
        'local-gw': 'test_value_64',
        'localid': 'test_value_65',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'name': 'default_name_70',
                'nattraversal': 'enable',
                'negotiate-timeout': '72',
                'peer': 'test_value_73',
                'peergrp': 'test_value_74',
                'peerid': 'test_value_75',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_78',
                'ppk-secret': 'test_value_79',
                'priority': '80',
                'proposal': 'des-md5',
                'psksecret': 'test_value_82',
                'psksecret-remote': 'test_value_83',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_86',
                'remotegw-ddns': 'test_value_87',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_92',
                'suite-b': 'disable',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_96',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_vpn_ipsec_phase1_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-negotiate': 'enable',
        'banner': 'test_value_14',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_19',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '22',
        'dns-mode': 'manual',
        'domain': 'test_value_24',
        'dpd': 'disable',
        'dpd-retrycount': '26',
        'dpd-retryinterval': 'test_value_27',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'enforce-unique-id': 'disable',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '33',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_35',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '38',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_41',
        'ipv4-dns-server1': 'test_value_42',
        'ipv4-dns-server2': 'test_value_43',
        'ipv4-dns-server3': 'test_value_44',
        'ipv4-end-ip': 'test_value_45',
        'ipv4-name': 'test_value_46',
        'ipv4-netmask': 'test_value_47',
        'ipv4-split-exclude': 'test_value_48',
        'ipv4-split-include': 'test_value_49',
        'ipv4-start-ip': 'test_value_50',
        'ipv4-wins-server1': 'test_value_51',
        'ipv4-wins-server2': 'test_value_52',
        'ipv6-dns-server1': 'test_value_53',
        'ipv6-dns-server2': 'test_value_54',
        'ipv6-dns-server3': 'test_value_55',
        'ipv6-end-ip': 'test_value_56',
        'ipv6-name': 'test_value_57',
        'ipv6-prefix': '58',
        'ipv6-split-exclude': 'test_value_59',
        'ipv6-split-include': 'test_value_60',
        'ipv6-start-ip': 'test_value_61',
        'keepalive': '62',
        'keylife': '63',
        'local-gw': 'test_value_64',
        'localid': 'test_value_65',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'name': 'default_name_70',
                'nattraversal': 'enable',
                'negotiate-timeout': '72',
                'peer': 'test_value_73',
                'peergrp': 'test_value_74',
                'peerid': 'test_value_75',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_78',
                'ppk-secret': 'test_value_79',
                'priority': '80',
                'proposal': 'des-md5',
                'psksecret': 'test_value_82',
                'psksecret-remote': 'test_value_83',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_86',
                'remotegw-ddns': 'test_value_87',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_92',
                'suite-b': 'disable',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_96',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_vpn_ipsec_phase1_removal(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'vpn_ipsec_phase1': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    delete_method_mock.assert_called_with('vpn.ipsec', 'phase1', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_vpn_ipsec_phase1_deletion_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'vpn_ipsec_phase1': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    delete_method_mock.assert_called_with('vpn.ipsec', 'phase1', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_vpn_ipsec_phase1_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-negotiate': 'enable',
        'banner': 'test_value_14',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_19',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '22',
        'dns-mode': 'manual',
        'domain': 'test_value_24',
        'dpd': 'disable',
        'dpd-retrycount': '26',
        'dpd-retryinterval': 'test_value_27',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'enforce-unique-id': 'disable',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '33',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_35',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '38',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_41',
        'ipv4-dns-server1': 'test_value_42',
        'ipv4-dns-server2': 'test_value_43',
        'ipv4-dns-server3': 'test_value_44',
        'ipv4-end-ip': 'test_value_45',
        'ipv4-name': 'test_value_46',
        'ipv4-netmask': 'test_value_47',
        'ipv4-split-exclude': 'test_value_48',
        'ipv4-split-include': 'test_value_49',
        'ipv4-start-ip': 'test_value_50',
        'ipv4-wins-server1': 'test_value_51',
        'ipv4-wins-server2': 'test_value_52',
        'ipv6-dns-server1': 'test_value_53',
        'ipv6-dns-server2': 'test_value_54',
        'ipv6-dns-server3': 'test_value_55',
        'ipv6-end-ip': 'test_value_56',
        'ipv6-name': 'test_value_57',
        'ipv6-prefix': '58',
        'ipv6-split-exclude': 'test_value_59',
        'ipv6-split-include': 'test_value_60',
        'ipv6-start-ip': 'test_value_61',
        'keepalive': '62',
        'keylife': '63',
        'local-gw': 'test_value_64',
        'localid': 'test_value_65',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'name': 'default_name_70',
                'nattraversal': 'enable',
                'negotiate-timeout': '72',
                'peer': 'test_value_73',
                'peergrp': 'test_value_74',
                'peerid': 'test_value_75',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_78',
                'ppk-secret': 'test_value_79',
                'priority': '80',
                'proposal': 'des-md5',
                'psksecret': 'test_value_82',
                'psksecret-remote': 'test_value_83',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_86',
                'remotegw-ddns': 'test_value_87',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_92',
                'suite-b': 'disable',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_96',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_vpn_ipsec_phase1_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1': {
            'random_attribute_not_valid': 'tag',
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_negotiate': 'enable',
            'banner': 'test_value_14',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_19',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '22',
            'dns_mode': 'manual',
            'domain': 'test_value_24',
            'dpd': 'disable',
            'dpd_retrycount': '26',
            'dpd_retryinterval': 'test_value_27',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'enforce_unique_id': 'disable',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '33',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_35',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '38',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_41',
            'ipv4_dns_server1': 'test_value_42',
            'ipv4_dns_server2': 'test_value_43',
            'ipv4_dns_server3': 'test_value_44',
            'ipv4_end_ip': 'test_value_45',
            'ipv4_name': 'test_value_46',
            'ipv4_netmask': 'test_value_47',
            'ipv4_split_exclude': 'test_value_48',
            'ipv4_split_include': 'test_value_49',
            'ipv4_start_ip': 'test_value_50',
            'ipv4_wins_server1': 'test_value_51',
            'ipv4_wins_server2': 'test_value_52',
            'ipv6_dns_server1': 'test_value_53',
            'ipv6_dns_server2': 'test_value_54',
            'ipv6_dns_server3': 'test_value_55',
            'ipv6_end_ip': 'test_value_56',
            'ipv6_name': 'test_value_57',
            'ipv6_prefix': '58',
            'ipv6_split_exclude': 'test_value_59',
            'ipv6_split_include': 'test_value_60',
            'ipv6_start_ip': 'test_value_61',
            'keepalive': '62',
            'keylife': '63',
            'local_gw': 'test_value_64',
            'localid': 'test_value_65',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'name': 'default_name_70',
            'nattraversal': 'enable',
            'negotiate_timeout': '72',
            'peer': 'test_value_73',
            'peergrp': 'test_value_74',
            'peerid': 'test_value_75',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_78',
            'ppk_secret': 'test_value_79',
            'priority': '80',
            'proposal': 'des-md5',
            'psksecret': 'test_value_82',
            'psksecret_remote': 'test_value_83',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_86',
            'remotegw_ddns': 'test_value_87',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_92',
            'suite_b': 'disable',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_96',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-negotiate': 'enable',
        'banner': 'test_value_14',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_19',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '22',
        'dns-mode': 'manual',
        'domain': 'test_value_24',
        'dpd': 'disable',
        'dpd-retrycount': '26',
        'dpd-retryinterval': 'test_value_27',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'enforce-unique-id': 'disable',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '33',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_35',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '38',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_41',
        'ipv4-dns-server1': 'test_value_42',
        'ipv4-dns-server2': 'test_value_43',
        'ipv4-dns-server3': 'test_value_44',
        'ipv4-end-ip': 'test_value_45',
        'ipv4-name': 'test_value_46',
        'ipv4-netmask': 'test_value_47',
        'ipv4-split-exclude': 'test_value_48',
        'ipv4-split-include': 'test_value_49',
        'ipv4-start-ip': 'test_value_50',
        'ipv4-wins-server1': 'test_value_51',
        'ipv4-wins-server2': 'test_value_52',
        'ipv6-dns-server1': 'test_value_53',
        'ipv6-dns-server2': 'test_value_54',
        'ipv6-dns-server3': 'test_value_55',
        'ipv6-end-ip': 'test_value_56',
        'ipv6-name': 'test_value_57',
        'ipv6-prefix': '58',
        'ipv6-split-exclude': 'test_value_59',
        'ipv6-split-include': 'test_value_60',
        'ipv6-start-ip': 'test_value_61',
        'keepalive': '62',
        'keylife': '63',
        'local-gw': 'test_value_64',
        'localid': 'test_value_65',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'name': 'default_name_70',
                'nattraversal': 'enable',
                'negotiate-timeout': '72',
                'peer': 'test_value_73',
                'peergrp': 'test_value_74',
                'peerid': 'test_value_75',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_78',
                'ppk-secret': 'test_value_79',
                'priority': '80',
                'proposal': 'des-md5',
                'psksecret': 'test_value_82',
                'psksecret-remote': 'test_value_83',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_86',
                'remotegw-ddns': 'test_value_87',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_92',
                'suite-b': 'disable',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_96',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
