/******************************************************************************
 * Copyright (c) 2014, AllSeen Alliance. All rights reserved.
 *
 *    Permission to use, copy, modify, and/or distribute this software for any
 *    purpose with or without fee is hereby granted, provided that the above
 *    copyright notice and this permission notice appear in all copies.
 *
 *    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ******************************************************************************/

#import <Foundation/Foundation.h>
#import "alljoyn/Status.h"
#import "AJNSessionOptions.h"
#import "alljoyn/gateway/GatewayMgmtApp.h"
#import "AJGWCAnnouncedApp.h"
#import "AJGWCGatewayMgmtApp.h"
#import "AJGWCSessionResult.h"
#import "AJGWCSessionListener.h"

@interface AJGWCGatewayMgmtApp : AJGWCAnnouncedApp

/**
 * Constructor
 * @param handle A handle to a cpp GatewayMgmtApp object
 */
- (id)initWithHandle:(ajn::gwc::GatewayMgmtApp*) handle;

/**
 * Constructor
 * @param busUniqueName The name of the {@link AJNBusAttachment} of the gateway that sent
 * the Announcement
 * @param aboutData The data sent with the Announcement
 */
- (id)initWithbusUniqueName:(NSString*) busUniqueName aboutData:(NSDictionary *) aboutData;

/**
 * Retrieve the list of applications installed on the gateway identified by the given gwBusName
 * @param sessionId The id of the session established with the gateway
 * @param connectorApps A reference to an array of The {@link AJGWCConnectorApp} installed applications
 * @return status of operation
 */
- (QStatus)retrieveConnectorApps:(AJNSessionId) sessionId connectorApps:(NSMutableArray*) connectorApps;

/**
 * Join session synchronously with the given gateway identified by the gwBusName.
 * This method doesn't require {@link AJGWCSessionListener}. Use this method
 * when there is no need to receive any session related event.
 * @return {@link AJGWCSessionResult}
 */
- (AJGWCSessionResult*)joinSession;

/**
 * Join session synchronously with the given gateway identified by the gwBusName.
 * The session related events will be sent to the given listener.
 * @param listener The listener is used to be notified about the session related events
 * @return {@link AJGWCSessionResult}
 */
- (AJGWCSessionResult*)joinSession:(id<AJGWCSessionListener>) listener;

/**
 * Join session asynchronously with the given gwBusName.
 * @param listener The listener is used to be notified about the session related events
 * @return Returns the joinSessionAsync status {@link QStatus}
 */
- (QStatus)joinSessionAsync:(id<AJGWCSessionListener>) listener;

/**
 * Disconnect the given session
 * @return Returns the leave session {@link QStatus}
 */
- (QStatus)leaveSession;

/**
 * Get the Listener defined for this SessionHandler
 * @return listener
 */
- (id<AJGWCSessionListener>)listener;

@end
