#
# Copyright 2005 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# Test the NamespaceMixin's set_value method
#
# $Id: set_value.py 8849 2007-03-13 04:49:27Z andrewm $

import unittest
import albatross

set_value = albatross.NamespaceMixin.set_value.im_func

class NS:
    pass

class SetValueTest(unittest.TestCase):
    def setUp(self):
        self.locals = NS()

    def _test(self, name, value):
        set_value(self, name, value)
        evaled = eval(name, {}, self.locals.__dict__)
        self.assertEqual(evaled, value)
    
    def set_test(self):
        self._test('a', 1)

    def errors_test(self):
        self.locals.b = 1
        self.assertRaises(AttributeError, set_value, self, 'a.b', 1)
        self.assertRaises(ValueError, set_value, self, 'b[a]', 1)
        self.assertRaises(SyntaxError, set_value, self, 'b[.a]', 1)
        self.assertRaises(SyntaxError, set_value, self, 'b[1.0]', 1)
        self.assertRaises(SyntaxError, set_value, self, 'b[1', 1)
        self.assertRaises(SyntaxError, set_value, self, 'b]', 1)
        self.assertRaises(SyntaxError, set_value, self, '.b', 1)
        self.assertRaises(SyntaxError, set_value, self, 'b.', 1)
        self.assertRaises(SyntaxError, set_value, self, '[0]', 1)

    def set_array_test(self):
        self.locals.b = [0] * 4
        self._test('b[0]', 1)
        self._test('b[2]', 2)
        self._test('b[-1]', 3)
        self.assertRaises(IndexError, set_value, self, 'b[4]', 1)
        self.assertEqual(self.locals.b, [1, 0, 2, 3])

    def set_sub_test(self):
        self.locals.c = NS()
        self.locals.c.e = [0] * 4
        f = NS()
        self.locals.c.e[3] = f
        self._test('c.d', 1)
        self._test('c.e[0]', 1)
        self._test('c.e[2]', 2)
        self._test('c.e[3].g', 3)
        self.assertRaises(IndexError, set_value, self, 'c.e[4]', 1)
        self.assertEqual(self.locals.c.e, [1, 0, 2, f])

    def iter_backdoor_test(self):
        class Iter:
            def set_backdoor(self, op, value):
                self.op = op
                self.value = value
        self.locals.f = Iter()
        self.locals.g = None
        set_value(self, 'x,f', 1)
        self.assertEqual(self.locals.f.op, 'x')
        self.assertEqual(self.locals.f.value, 1)
        self.assertRaises(AttributeError, set_value, self, 'x,g', 1)

    def array_array_test(self):
        self.locals.g = [[0] * 3] * 3
        self._test('g[1][2]', 2)

class Suite(unittest.TestSuite):
    def __init__(self):
        tests = [SetValueTest(meth) 
                 for meth in dir(SetValueTest)
                 if not meth.startswith('_') and meth.endswith('_test')]
        unittest.TestSuite.__init__(self, tests)

def suite():
    return Suite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')

