C
C THIS ROUTINE RETURNS THE APPROPRIATE GATHER/SCATTER VECTORS NEEDED
C   TO READ IN A FULL DISTRIBUTION INTO A SYMMETRY-PACKED ARRAY.
C
C  INPUT:
C
C    LEFTP = STORAGE SCHEME FOR DISTRIBUTION MEMBERS (SEE JOBARC LIST).
C    LENGTH= DISTRIBUTION SIZE (IN FLOATING POINT WORDS).
C    RIGHTP= STORAGE SCHEME FOR DISTRIBUTIONS (SEE JOBARC LIST).
C    NUMDIS= NUMBER OF TOTAL DISTRIBUTIONS.
C    NIRREP= THE TOTAL NUMBER OF IRREDUCIBLE REPRESENTATIONS.
C
C  OUTPUT:
C
C    NUMIRR= POPULATION COUNT SYMMETRY VECTORS (SEE JOBARC LIST).
C             THE FIRST NIRREP ELEMENTS CORRESPOND TO THE DISTRIBUTIONS
C             WHILE THE LAST NIRREP ELEMENTS REFER TO THE DISTRIBUTION
C             MEMBERS.
C    IBUF  = SYMMETRY VECTORS (SEE JOBARC LIST).  
C             THE FIRST NUMDIS MEMBERS REFER TO THE DISTRIBUTIONS WHILE
C             THE LAST LENGTH MEMBERS REFER TO THE DISTRIBUTION MEMBERS.
C
      SUBROUTINE GETGSV(LEFTP,LENGTH,RIGHTP,NUMDIS,NIRREP,NUMIRR,IBUF)
      IMPLICIT INTEGER (A-Z)
      INTEGER RIGHTP,LEFTP
      CHARACTER*6 SYMLST(22)
      DIMENSION IBUF(NUMDIS+LENGTH),NUMIRR(2*NIRREP)
      DATA SYMLST /'SVAVA0','SVBVB0','SOAOA0','SOBOB0',
     &             'SVAVA1','SVBVB1','SOAOA1','SOBOB1',
     &             'SVAOA2','SVBOB2','SOBVA2','SVBOA2',
     &             'SVAVB2','SOAOB2','SVAVB2','SOAVA2',
     &             'SOBVB2','SOAVB2','SVAVA2','SVBVB2',
     &             'SOAOA2','SOBOB2'/

C PICK UP SYMMETRY VECTORS FOR RIGHTP (REFERS TO THE DISTRIBUTION
C    NUMBER, RATHER THAN THE MEMBERS OF THE DISTRIBUTION ITSELF).
      CALL GETREC(1,'JOBARC',SYMLST(RIGHTP)//'X',NIRREP,NUMIRR)
      CALL GETREC(1,'JOBARC',SYMLST(RIGHTP),     NUMDIS,IBUF)

C PICK UP SYMMETRY VECTORS FOR LEFTP (REFERS TO THE INDIVIDUAL
C    MEMBERS OF THE DISTRIBUTION).
      CALL GETREC(1,'JOBARC',SYMLST(LEFTP)//'X',NIRREP,NUMIRR(NIRREP+1))
      CALL GETREC(1,'JOBARC',SYMLST(LEFTP),     LENGTH,IBUF(NUMDIS+1))
      RETURN
      END

