/* test.h - test interface
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_TEST_H
#define ABX_TEST_H

#include "soundfile.h"
#include "playback.h"

typedef enum { SAMPLE_A, SAMPLE_B, SAMPLE_NA } answer;

extern int init_test (const char *a, const char *b, 
                      unsigned int ntrials, PaDeviceIndex outdev);
extern void close_test(void);
extern int is_test_valid(void);
extern int num_test_trials(void);
extern answer get_answer(unsigned int t);
extern answer get_guess(unsigned int t);
extern int set_guess(unsigned int t, answer ans);
extern double calculate_p_value(void);

#endif
