!{\src2tex{textfont=tt}}
!!****f* ABINIT/findshells
!! NAME
!! findshells
!!
!! FUNCTION
!! Find the g-vector numbers that close a shell
!! Check if ngs closes a shell
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  gvec(3,ng)=coordinated of G vectors
!!  ng=number of G vectors
!!  ngs=tentative number of G vectors at which a shell is closed
!!
!!
!! OUTPUT
!!  (only checking)
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine findshells(b1,b2,b3,ng,ngs,gvec)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => findshells
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer :: ng,ngs
!arrays
 integer :: gvec(3,ng)
 real(dp) :: b1(3),b2(3),b3(3)

!Local variables ------------------------------
!scalars
 integer :: ig,s
 real(dp) :: l,lold
 logical :: shellclosed=.false.
 character(len=500) :: message
!arrays
 real(dp) :: g(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vlngth
#endif
!End of the abilint section

 write(message,'(a)')' shell  g-vector     radius [au]'
 call wrtout(06,message,'COLL')
 s=0
 g(:)=gvec(:,1)
 lold=vlngth(g,b1,b2,b3)
 do ig=2,ng
   g(:)=gvec(:,ig)
   l=vlngth(g,b1,b2,b3)
   if((l-lold)>0.000001) then
     write(message,'(i6,i10,f11.6)')s,ig-1,lold
     call wrtout(06,message,'COLL')
     lold=l
     s=s+1
     if(ngs==ig-1) shellclosed=.true.
   end if
 end do

 if(shellclosed) then
  write(message,'(a,i8,a)')' shell closed at ',ngs,ch10
  call wrtout(06,message,'COLL')
 else if(ngs==ng) then
  write(message,'(a,i8,a)')' shell probably closed at ',ngs,ch10
  call wrtout(06,message,'COLL')
 else
  write(message,'(a)')&
& ' findshell: ERROR- ',ch10,&
& ' shell not closed'
  call wrtout(06,message,'COLL')
  write(*,*) 'npwsigx = ',ngs
  call leave_new('COLL')
 end if

end subroutine findshells
!!***
