!{\src2tex{textfont=tt}}
!!****f* ABINIT/cppm3par
!! NAME
!! cppm3par
!!
!! FUNCTION
!! Calculate the plasmon-pole parameters using von Linden-Horsh (PRB 37, 8351, 1988)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (RShaltaf,GMR,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  epsm1(npwvec,npwvec,nomega,nq)=dielectric matrix at nomega frequencies, and nq wavevectors
!!  mpi_enreg=informations about MPI parallelization
!!  npwvec=number of plane waves
!!  qratio=(q+G).(q+G')/(|q+G|.|q+G"|)
!!  rho=charge deinsity on real space FFT grid
!!  ngfft1,ngfft2,ngfft3=FFT grid
!!  nr=ngfft1*ngfft2*ngfft3
!!  gvec= G vectors in reduced reciproal
!! OUTPUT
!!  omegatw(npwvec,npwvec,nq)=plasmon pole position
!!  bigomegatwsq(npwvec,npwvec,nq)=(Ei^-1-1)*omegatw
!!  where Ei^-1 is the eigval of the inverse dielectric matrix
!!  eigtot=the eigvec of the inverse dielctric matrix
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      cggfft,chpev,fourdp,leave_new,wrtout,zhpev
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cppm3par(npwvec,nq,nomega,epsm1,bigomegatwsq,omegatw,&
& ngfft1,ngfft2,ngfft3,gvec,rho,nr,eigtot,q,b1,b2,b3)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15gw, except_this_one => cppm3par
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngfft1,ngfft2,ngfft3,nomega,npwvec,nq,nr
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),q(3,nq)
 real(dp),intent(inout) :: rho(nr)
 complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
 complex,intent(out) :: bigomegatwsq(npwvec,1,nq),eigtot(npwvec,npwvec,nq)
 complex,intent(out) :: omegatw(npwvec,1,nq)

!Local variables-------------------------------
!scalars
 integer :: ierr,ig,igp,ii,index,iq,istat,jj,tim_fourdp=2
 real(dp) :: num,qpg_dot_qpgp
 character(len=1) :: jobs,uplo
 character(len=5000) :: message
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: ngfft(18)
 integer,allocatable :: igfft(:,:)
 real(dp) :: gppq(3),gpq(3)
 real(dp),allocatable :: eigval(:),qplusg(:),rhog_dp(:,:),zhpev2(:)
!no_abirules
 complex*16::conjg_eig
 COMPLEX*16,allocatable::matr(:),zhpev1(:),eigvec(:,:)
 COMPLEX*16,allocatable::zz(:,:),temp(:,:),mm(:,:,:)
 COMPLEX*16,allocatable :: omegatwsq(:,:),rhog(:),rhogg(:,:)

!*************************************************************************

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'ZHPEV' :: zhpev
#endif

! compute the density in G space rhog(G)
  allocate(rhog_dp(2,nr),stat=istat)
  if(istat/=0) stop 'rhog_dp out of memory'
  allocate(rhog(nr),stat=istat)
  if(istat/=0) stop 'rhog out of memory'
  allocate(igfft(npwvec,npwvec),stat=istat)
  if(istat/=0) stop 'igfft out of memory'
  allocate(rhogg(npwvec,npwvec),stat=istat)
  if(istat/=0) stop 'rhogg out of memory'

  ngfft(1)=ngfft1
  ngfft(2)=ngfft2
  ngfft(3)=ngfft3
  ngfft(4)=2*(ngfft(1)/2)+1
  ngfft(5)=2*(ngfft(2)/2)+1
  ngfft(6)=ngfft(3)
  ngfft(7)=100
  ngfft(8)=256
  ngfft(9)=0
  ngfft(10)=1
  ngfft(11)=0
  ngfft(12)=ngfft2
  ngfft(13)=ngfft3
  ngfft(14)=0

! conduct FFT to rhog

 call fourdp(1,rhog_dp,rho,-1,mpi_enreg,nr,ngfft,0)
 rhog(1:nr)=cmplx(rhog_dp(1,1:nr),rhog_dp(2,1:nr))

! calculate the FFT index of each (G-G') vector and assign the value
! of correspondent density simultanously

 call cggfft(npwvec,ngfft1,ngfft2,ngfft3,gvec,igfft)
 do ig=1,npwvec
  do igp=1,npwvec
   if(igfft(ig,igp)>nr)then
   write (message,'(a,a,a)') &
   &'BUG:can not find rho(G-Gpr) for some G, Gpr, contact ABINIT group',ch10,&
   &'program will stop'
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
   end if
   rhogg(ig,igp)=rhog(igfft(ig,igp))
  end do
 end do

 allocate(mm(npwvec,npwvec,nq),stat=istat)
 if(istat/=0) stop 'mm out of memory'
 do iq=1,nq
  do ig=1,npwvec
   if(all(abs(q(:,iq))<1.0e-3))then
    gpq(1)=gvec(1,ig)
    gpq(2)=gvec(2,ig)
    gpq(3)=gvec(3,ig)
   else
   gpq(1)=gvec(1,ig)+q(1,iq)
   gpq(2)=gvec(2,ig)+q(2,iq)
   gpq(3)=gvec(3,ig)+q(3,iq)
    end if
   do igp=1,npwvec
   if(all(abs(q(:,iq))<1.0e-3))then
   gppq(1)=gvec(1,igp)
   gppq(2)=gvec(2,igp)
   gppq(3)=gvec(3,igp)
   else
    gppq(1)=gvec(1,igp)+q(1,iq)
    gppq(2)=gvec(2,igp)+q(2,iq)
    gppq(3)=gvec(3,igp)+q(3,iq)
    end if
    qpg_dot_qpgp=0
     do ii=1,3
      qpg_dot_qpgp=qpg_dot_qpgp+&
 &     (gpq(1)*b1(ii) +gpq(2)*b2(ii) +gpq(3)*b3(ii))*&
 &     (gppq(1)*b1(ii)+gppq(2)*b2(ii)+gppq(3)*b3(ii))
       end do
       mm(ig,igp,iq)= rhogg(ig,igp)*qpg_dot_qpgp
      end do     !igp
      end do    !ig
 end do  !iq

!Now we have rhogg,rho0

 deallocate(rhog_dp,rhog,igfft)

!calculate the dielectric matrix eignvalues and vectors


!only we will use the static DM i.e., only the w=0 part (eps(:,:,1,:))

 allocate(eigval(npwvec),stat=istat)
 if(istat/=0) stop 'eigval out of memory'
 allocate(eigvec(npwvec,npwvec),stat=istat)  ! eigenvalues and vectors of DM
 if(istat/=0) stop 'eigvec out of memory'
 allocate(temp(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'temp out of memory'
 allocate(zz(npwvec,nq),stat=istat)
 if(istat/=0) stop 'zz of memory'

 zz(:,:)=0.0

 allocate(qplusg(npwvec),stat=istat)
 if(istat/=0) stop 'qplusg out of memory'

 do iq=1,nq


! Store the susceptibility matrix in upper mode before calling zhpev for each iq value

  allocate(matr(npwvec*(npwvec+1)/2),stat=istat)
  if(istat/=0) stop 'matr of memory'

  index=1
  do ii=1,npwvec
   do jj=1,ii
    matr(index)=epsm1(jj,ii,1,iq)
    index=index+1
   end do
  end do
  allocate(zhpev2(3*npwvec-2),stat=istat)
  if(istat/=0) stop 'zhpev2 of memory'
  allocate(zhpev1(2*npwvec-1),stat=istat)
  if(istat/=0) stop 'zhpev1 of memory' ! woking arrays for lapack

#if defined T3E
  call CHPEV('V','U',npwvec,matr,eigval,eigvec,npwvec,&
& zhpev1,zhpev2,ierr)
#else
  call zhpev('V','U',npwvec,matr,eigval,eigvec,npwvec,&
 &zhpev1,zhpev2,ierr)
#endif

  deallocate(matr,zhpev2,zhpev1) !! woking arrays for lapack

  if (ierr<0) then
   write (message,'(a,a,i4,a,a)') &
&   'failed to calculate the eignvalues and eignvaectors of the dielectric matrix ',ch10,&
&   ierr*(-1),'th argument in the matrix had an illegal value',ch10
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
  end if

  if (ierr>0) then
   write (message,'(3a,i4,4a)') &
&   'failed to calculate the eigenvalues and eigenvectors of the dielectric matrix ',ch10,&
&   'the algorithm failed to converge;', ierr, 'off-diagonal elements of an intermediate tridiagonal form',ch10,&
&   'did not converge to zero.',ch10
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
  end if

! calculate the PPM parameters and the eignpotentials needed for the calculation
! of the generalized overlap matrix
! Note: the eigenpotentials has to be calculated on the FFT (G-Gpr) index

  eigtot(:,:,iq)=eigvec(:,:)
  call cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)
  do ii=1,npwvec
   if(iq==1)then
    eigvec(2:,ii)=eigvec(2:,ii)/qplusg(2:)
   else
    eigvec(:,ii)=eigvec(:,ii)/qplusg(:)
   end if
   do ig=1,npwvec
    conjg_eig=conjg(eigvec(ig,ii))
    do igp=1,npwvec
     if(iq==1.and.ig==1.and.igp==1)then
      zz(ii,iq)=zz(ii,iq)+conjg_eig*rhogg(ig,igp)*eigvec(igp,ii)
     else
      zz(ii,iq)=zz(ii,iq)+conjg_eig*mm(ig,igp,iq)*eigvec(igp,ii)
     end if
    end do
   end do

   num=1-eigval(ii)
   if(num<=0.0_dp)then
    if(abs(num)<1.0d-4)then
     num=1.0d-5
    else
     write (message,'(a,a,a)') &
&     'BUG:one or more imaginary plasmon pole energies, contact ABINIT group',ch10,&
&     'program will stop'
     call wrtout(ab_out,message,'COLL')
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
    end if
   end if
   omegatw(ii,1,iq)=sqrt(4*pi*real(zz(ii,iq))/(num))
   bigomegatwsq(ii,1,iq)=num*omegatw(ii,1,iq)
  end do
 end do !iq
 deallocate(rhogg)

 deallocate(temp,mm)
 deallocate(eigval,zz)
 deallocate(eigvec,qplusg)
end subroutine cppm3par
!!***
