!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_mkrho
!! NAME
!! wvl_mkrho
!!
!! FUNCTION
!! This method is just a wrapper around the BigDFT routine to compute the
!! density from the wavefunctions.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  mpi_enreg=informations about MPI parallelization
!!  occ(dtset%mband)=occupation numbers.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!
!! OUTPUT
!!  rhor(dtset%nfft)=electron density in r space
!!
!! SIDE EFFECTS
!!  proj <type(wvl_projector_type)>=projectors informations for wavelets.
!!   | proj(OUT)=computed projectors.
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_mkrho(dtset, mpi_enreg, occ, rhor, wfs)

  use defs_basis
  use defs_datatypes
#if defined HAVE_BIGDFT
  use libbigdft
#endif

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

  implicit none

!Arguments -------------------------------
  type(dataset_type), intent(in)            :: dtset
  type(MPI_type), intent(in)                :: mpi_enreg
  type(wvl_wf_type), intent(in)             :: wfs
  real(dp), intent(in)                      :: occ(dtset%mband)
  real(dp), intent(inout)                     :: rhor(dtset%nfft)

!Locals
  character(len = 500)  :: message
  logical               :: paralel

#if defined HAVE_BIGDFT
#if defined MPI
  paralel = .true.
#else
  paralel = .false.
#endif

  ! If wavefunctions are under initialisation from atomic orbitals,
  ! we must use wfs%psi_init instead of wfs%psi as wavefunctions
  ! used to compute the density.
  if (wfs%mband_init > 0) then
    ! Initialisation case.
    call sumrho(paralel, mpi_enreg%me, wfs%mband_init, wfs%mbandp_init, &
              & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
              & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid, wfs%occ_init, &
              & wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%nvctr(0), &
              & wfs%keys%nvctr(1), wfs%keys%keyg, wfs%keys%keyv, wfs%psi_init, rhor)
  else
    call sumrho(paralel, mpi_enreg%me, dtset%mband, wfs%mbandp, &
              & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
              & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid, occ, &
              & wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%nvctr(0), &
              & wfs%keys%nvctr(1), wfs%keys%keyg, wfs%keys%keyv, wfs%psi, rhor)
  end if
  
#else
  write(message, '(a,a,a,a)' ) ch10,&
    &  ' wvl_mkrho : BigDFT library is not compiled.', ch10, &
    &  '   Action, used the flag --enable-bigdft when configuring.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
#endif
end subroutine wvl_mkrho
!!***
