#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Osmos
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220705.1

GAME_ID='osmos'
GAME_NAME='Osmos'

ARCHIVE_BASE_0='Osmos_1.6.1.tar.gz'
ARCHIVE_BASE_0_MD5='ed2cb029c20c25de719c28062e6fc9cf'
ARCHIVE_BASE_0_SIZE='32000'
ARCHIVE_BASE_0_VERSION='1.6.1-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/osmos'

CONTENT_PATH_DEFAULT='Osmos'
ARCHIVE_DOC_DATA_FILES='
*.txt
*.html'
ARCHIVE_GAME_BIN32_FILES='
Osmos.bin32'
ARCHIVE_GAME_BIN64_FILES='
Osmos.bin64'
ARCHIVE_GAME_DATA_FILES='
*.cfg
*.loc
Fonts
Icons
Sounds
Textures'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='Osmos.bin32'
APP_MAIN_EXE_BIN64='Osmos.bin64'
for icon_size in 16 22 32 36 48 64 72 96 128 192 256; do
	APP_MAIN_ICONS_LIST="$APP_MAIN_ICONS_LIST APP_MAIN_ICON_${icon_size}"
	export APP_MAIN_ICON_${icon_size}="Icons/${icon_size}x${icon_size}.png"
done

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libopenal.so.1 libGLU.so.1 libvorbisfile.so.3"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Use persistent storage for user data

DATA_FILES='*.cfg'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
