#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Beautiful Desolation
# send your bug reports to contact@dotslashplay.it
###

script_version=20230414.1

GAME_ID='beautiful-desolation'
GAME_NAME='Beautiful Desolation'

ARCHIVE_BASE_1='beautiful_desolation_1_0_5_5_44769.sh'
ARCHIVE_BASE_1_MD5='0656c2fb0ef2ad2bc0087d16f5d02e46'
ARCHIVE_BASE_1_SIZE='16000000'
ARCHIVE_BASE_1_VERSION='1.0.5.5-gog44769'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/beautiful_desolation'

ARCHIVE_BASE_0='beautiful_desolation_1_0_3_9_38147.sh'
ARCHIVE_BASE_0_MD5='18fe66cffc59f033a4d057233b1ebb1f'
ARCHIVE_BASE_0_SIZE='14000000'
ARCHIVE_BASE_0_VERSION='1.0.3.9-gog38147'

UNITY3D_NAME='desolation'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/Mono/x86_64
${UNITY3D_NAME}_Data/Plugins/x86_64"
CONTENT_GAME_DATA_VIDEO_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/videoEncoded
${UNITY3D_NAME}_Data/StreamingAssets/videoEncoded_webm
${UNITY3D_NAME}_Data/StreamingAssets/bundles/videoencoded_mp4-media_*"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

PACKAGES_LIST='PKG_BIN PKG_DATA_VIDEO PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_VIDEO_ID="${PKG_DATA_ID}-video"
PKG_DATA_VIDEO_DESCRIPTION="$PKG_DATA_DESCRIPTION - video"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_VIDEO_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
