#!/bin/bash

################################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $4 $6/mof/OpenDRIM_RegisteredIPProtocolProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_RegisteredIPProtocolProfile provider module";
Name = "IP_OpenDRIM_RegisteredIPProtocolProfileModule";
Location = "cmpiIP_OpenDRIM_RegisteredIPProtocolProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_RegisteredIPProtocolProfile provider";
Name = "IP_OpenDRIM_RegisteredIPProtocolProfileProvider";
ProviderModuleName = "IP_OpenDRIM_RegisteredIPProtocolProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_RegisteredIPProtocolProfile provider capabilities";
ProviderModuleName = "IP_OpenDRIM_RegisteredIPProtocolProfileModule";
ProviderName = "IP_OpenDRIM_RegisteredIPProtocolProfileProvider";
ClassName = "OpenDRIM_RegisteredIPProtocolProfile";
ProviderType = {2};
Namespaces = {"$4"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID", "RegisteredOrganization", "OtherRegisteredOrganization", "RegisteredName", "RegisteredVersion", "AdvertiseTypes", "AdvertiseTypeDescriptions"};
CapabilityID = "IP_OpenDRIM_RegisteredIPProtocolProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_RegisteredIPProtocolProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_RegisteredIPProtocolProfile]   
   provider: IP_OpenDRIM_RegisteredIPProtocolProfileProvider
   location: cmpiIP_OpenDRIM_RegisteredIPProtocolProfileProvider
   type: instance
   namespace: $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_RegisteredIPProtocolProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_RegisteredIPProtocolProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_RegisteredIPProtocolProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
