/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.AssocDataListChunk;
import edu.harvard.hul.ois.jhove.module.wave.BroadcastExtChunk;
import edu.harvard.hul.ois.jhove.module.wave.CartChunk;
import edu.harvard.hul.ois.jhove.module.wave.CueChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataChunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.FactChunk;
import edu.harvard.hul.ois.jhove.module.wave.FormatChunk;
import edu.harvard.hul.ois.jhove.module.wave.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoChunk;
import edu.harvard.hul.ois.jhove.module.wave.MpegChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import edu.harvard.hul.ois.jhove.module.wave.PeakEnvelopeChunk;
import edu.harvard.hul.ois.jhove.module.wave.SampleChunk;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class WaveModule
extends ModuleBase {
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected List _propList;
    protected List _notes;
    protected List _labels;
    protected List _labeledText;
    protected List _samples;
    protected AESAudioMetadata _aesMetadata;
    protected long bytesRemaining;
    protected int _blockAlign;
    protected ExifInfo _exifInfo;
    protected int compressionCode;
    protected long numSamples;
    protected long sampleRate;
    protected boolean formatChunkSeen;
    protected boolean factChunkSeen;
    protected boolean dataChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean mpegChunkSeen;
    protected boolean cartChunkSeen;
    protected boolean broadcastExtChunkSeen;
    protected boolean peakChunkSeen;
    protected boolean linkChunkSeen;
    protected boolean cueChunkSeen;
    protected boolean flagPCMWaveFormat;
    protected boolean flagWaveFormatEx;
    protected boolean flagWaveFormatExtensible;
    protected boolean flagBroadcastWave;
    protected int broadcastVersion;
    protected boolean firstSampleOffsetMarked;
    private static final int[] sigByte = new int[]{82, 73, 70, 70};
    private static final String NAME = "WAVE-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2007, 12, 14};
    private static final String[] FORMAT = new String[]{"WAVE", "Audio for Windows", "EBU Technical Specification 3285", "Broadcast Wave Format", "BWF"};
    private static final String COVERAGE = "WAVE (WAVEFORMAT, PCMWAVEFORMAT, WAVEFORMATEX, WAVEFORMATEXTENSIBLE), Broadcast Wave Format (BWF) version 0 and 1";
    private static final String[] MIMETYPE = new String[]{"audio/x-wave", "audio/wave"};
    private static final String WELLFORMED = null;
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "There is no published standard for WAVE files. This module regards a file as valid if it conforms to common usage practices.";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public WaveModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Agent agent2 = new Agent("Microsoft Corporation", AgentType.COMMERCIAL);
        agent2.setAddress(" One Microsoft Way, Redmond, WA 98052-6399");
        agent2.setTelephone("+1 (800) 426-9400");
        agent2.setWeb("http://www.microsoft.com");
        Document document = new Document("PCMWAVEFORMAT", DocumentType.WEB);
        document.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_pcmwaveformat_str.asp", IdentifierType.URL));
        document.setPublisher(agent2);
        this._specification.add(document);
        document = new Document("WAVEFORMATEX", DocumentType.WEB);
        document.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatex_str.asp", IdentifierType.URL));
        document.setPublisher(agent2);
        this._specification.add(document);
        document = new Document("WAVEFORMATEXTENSIBLE", DocumentType.WEB);
        document.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatextensible_str.asp", IdentifierType.URL));
        document.setPublisher(agent2);
        this._specification.add(document);
        agent = new Agent("European Broadcasting Union", AgentType.COMMERCIAL);
        agent.setAddress("Casa postale 45, Ancienne Route 17A, CH-1218 Grand-Saconex, Geneva, Switzerland");
        agent.setTelephone("+ 41 (0)22 717 2111");
        agent.setFax("+ 41 (0)22 747 4000");
        agent.setEmail("techreview@ebu.ch");
        agent.setWeb("http://www.ebu.ch");
        document = new Document("Broadcast Wave Format (EBU N22-1987)", DocumentType.REPORT);
        document.setIdentifier(new Identifier("http://www.ebu.ch/CMSimages/en/tec_doc_t3285_tcm6-10544.pdf", IdentifierType.URL));
        document.setPublisher(agent);
        this._specification.add(document);
        ExternalSignature externalSignature = new ExternalSignature(".wav", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(externalSignature);
        externalSignature = new ExternalSignature(".bwf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For BWF profile");
        this._signature.add(externalSignature);
        externalSignature = new InternalSignature("RIFF", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(externalSignature);
        externalSignature = new InternalSignature("WAVE", SignatureType.MAGIC, SignatureUseType.MANDATORY, 8);
        this._signature.add(externalSignature);
        this._bigEndian = false;
    }

    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        String string;
        this.initParse();
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        this._aesMetadata.setPrimaryIdentifier(repInfo.getUri());
        if (repInfo.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, this._ckSummer);
            this._dstream = WaveModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = WaveModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        try {
            for (int i = 0; i < 4; ++i) {
                int n2 = WaveModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (n2 == sigByte[i]) continue;
                repInfo.setMessage((Message)new ErrorMessage("Document does not start with RIFF chunk", 0L));
                repInfo.setWellFormed(false);
                return 0;
            }
            repInfo.setSigMatch(this._name);
            this.bytesRemaining = this.readUnsignedInt(this._dstream);
            string = this.read4Chars(this._dstream);
            this.bytesRemaining -= 4L;
            if (!"WAVE".equals(string)) {
                repInfo.setMessage((Message)new ErrorMessage("File type in RIFF header is not WAVE", this._nByte));
                repInfo.setWellFormed(false);
                return 0;
            }
            while (this.bytesRemaining > 0L && this.readChunk(repInfo)) {
            }
        }
        catch (EOFException eOFException) {
            repInfo.setWellFormed(false);
            repInfo.setMessage((Message)new ErrorMessage("Unexpected end of file", this._nByte));
            return 0;
        }
        if (this.numSamples > 0L) {
            this._aesMetadata.setDuration(this.numSamples);
        }
        if (!this._labels.isEmpty()) {
            this._propList.add(new Property("Labels", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._labels));
        }
        if (!this._labeledText.isEmpty()) {
            this._propList.add(new Property("LabeledText", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._labeledText));
        }
        if (!this._notes.isEmpty()) {
            this._propList.add(new Property("Notes", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._notes));
        }
        if (!this._samples.isEmpty()) {
            this._propList.add(new Property("Samples", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._samples));
        }
        if (this._exifInfo != null) {
            this._propList.add(this._exifInfo.buildProperty());
        }
        if (!this.formatChunkSeen) {
            repInfo.setMessage((Message)new ErrorMessage("No Format Chunk"));
            repInfo.setWellFormed(false);
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                int n3;
                while ((n3 = this.skipBytes(this._dstream, 2048, this)) != 0) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            repInfo.setSize(this._cstream.getNBytes());
            repInfo.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            string = this._ckSummer.getMD5();
            if (string != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
            }
            if ((string = this._ckSummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
            }
        }
        repInfo.setProperty(this._metadata);
        if (this.flagPCMWaveFormat) {
            repInfo.setProfile("PCMWAVEFORMAT");
        }
        if (this.flagWaveFormatEx) {
            repInfo.setProfile("WAVEFORMATEX");
        }
        if (this.flagWaveFormatExtensible) {
            repInfo.setProfile("WAVEFORMATEXTENSIBLE");
        }
        if (this.flagBroadcastWave) {
            if (!this.broadcastExtChunkSeen) {
                this.flagBroadcastWave = false;
            }
            if (!(this.compressionCode != 80 || this.broadcastExtChunkSeen && this.factChunkSeen)) {
                this.flagBroadcastWave = false;
            }
            if (this.flagBroadcastWave) {
                string = null;
                switch (this.broadcastVersion) {
                    case 0: {
                        string = "Broadcast Wave Version 0";
                        break;
                    }
                    case 1: {
                        string = "Broadcast Wave Version 1";
                    }
                }
                if (string != null) {
                    repInfo.setProfile(string);
                }
            }
        }
        return 0;
    }

    public void markFirstSampleOffset() {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte);
        }
    }

    public void setExifInfo(ExifInfo exifInfo) {
        this._exifInfo = exifInfo;
    }

    public void setBlockAlign(int n) {
        this._blockAlign = n;
    }

    public ExifInfo getExifInfo() {
        return this._exifInfo;
    }

    public int getCompressionCode() {
        return this.compressionCode;
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public void addWaveProperty(Property property) {
        this._propList.add(property);
    }

    public void addLabel(Property property) {
        this._labels.add(property);
    }

    public void addLabeledText(Property property) {
        this._labeledText.add(property);
    }

    public void addSample(Property property) {
        this._samples.add(property);
    }

    public void addNote(Property property) {
        this._notes.add(property);
    }

    public void addListInfo(List list) {
        this._propList.add(new Property("ListInfo", PropertyType.PROPERTY, PropertyArity.LIST, (Object)list));
    }

    public long readSignedLong(DataInputStream dataInputStream) throws IOException {
        return WaveModule.readSignedLong((DataInputStream)dataInputStream, (boolean)false, (ModuleBase)this);
    }

    public long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        return WaveModule.readUnsignedInt((DataInputStream)dataInputStream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedInt(DataInputStream dataInputStream) throws IOException {
        return WaveModule.readSignedInt((DataInputStream)dataInputStream, (boolean)false, (ModuleBase)this);
    }

    public int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        return WaveModule.readUnsignedShort((DataInputStream)dataInputStream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedShort(DataInputStream dataInputStream) throws IOException {
        return WaveModule.readSignedShort((DataInputStream)dataInputStream, (boolean)false, (ModuleBase)this);
    }

    public String read4Chars(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int n = WaveModule.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this);
            if (n == 0) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public void setCompressionCode(int n) {
        this.compressionCode = n;
    }

    public void addSamples(long l) {
        this.numSamples += l;
    }

    public void setSampleRate(long l) {
        this.sampleRate = l;
    }

    public void setPCMWaveFormat(boolean bl) {
        this.flagPCMWaveFormat = bl;
    }

    public void setWaveFormatEx(boolean bl) {
        this.flagWaveFormatEx = bl;
    }

    public void setWaveFormatExtensible(boolean bl) {
        this.flagWaveFormatExtensible = bl;
    }

    public void setBroadcastWave(boolean bl) {
        this.flagBroadcastWave = bl;
    }

    public void setBroadcastVersion(int n) {
        this.broadcastVersion = n;
    }

    protected void initParse() {
        super.initParse();
        this._propList = new LinkedList();
        this._notes = new LinkedList();
        this._labels = new LinkedList();
        this._labeledText = new LinkedList();
        this._samples = new LinkedList();
        this.firstSampleOffsetMarked = false;
        this.numSamples = 0L;
        this._metadata = new Property("WAVEMetadata", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._propList);
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setByteOrder(1);
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("WAVE");
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, (Object)this._aesMetadata));
        this.formatChunkSeen = false;
        this.dataChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.cartChunkSeen = false;
        this.mpegChunkSeen = false;
        this.broadcastExtChunkSeen = false;
        this.peakChunkSeen = false;
        this.linkChunkSeen = false;
        this.cueChunkSeen = false;
        this.flagPCMWaveFormat = false;
        this.flagWaveFormatEx = false;
        this.flagWaveFormatExtensible = false;
        this.flagBroadcastWave = false;
    }

    protected boolean readChunk(RepInfo repInfo) throws IOException {
        Chunk chunk = null;
        ChunkHeader chunkHeader = new ChunkHeader(this, repInfo);
        if (!chunkHeader.readHeader(this._dstream)) {
            return false;
        }
        int n = (int)chunkHeader.getSize();
        this.bytesRemaining -= (long)(n + 8);
        if (this.bytesRemaining < 0L) {
            repInfo.setMessage((Message)new ErrorMessage("Invalid chunk size", this._nByte));
            return false;
        }
        String string = chunkHeader.getID();
        if ("fmt ".equals(string)) {
            if (this.formatChunkSeen) {
                this.dupChunkError(repInfo, "Format");
            }
            chunk = new FormatChunk(this, chunkHeader, this._dstream);
            this.formatChunkSeen = true;
        } else if ("data".equals(string)) {
            if (this.dataChunkSeen) {
                this.dupChunkError(repInfo, "Data");
            }
            chunk = new DataChunk(this, chunkHeader, this._dstream);
            this.dataChunkSeen = true;
        } else if ("fact".equals(string)) {
            chunk = new FactChunk(this, chunkHeader, this._dstream);
            this.factChunkSeen = true;
        } else if ("note".equals(string)) {
            chunk = new NoteChunk(this, chunkHeader, this._dstream);
        } else if ("labl".equals(string)) {
            chunk = new LabelChunk(this, chunkHeader, this._dstream);
        } else if ("list".equals(string)) {
            chunk = new AssocDataListChunk(this, chunkHeader, this._dstream, repInfo);
        } else if ("LIST".equals(string)) {
            chunk = new ListInfoChunk(this, chunkHeader, this._dstream, repInfo);
        } else if ("smpl".equals(string)) {
            chunk = new SampleChunk(this, chunkHeader, this._dstream);
        } else if ("inst".equals(string)) {
            if (this.instrumentChunkSeen) {
                this.dupChunkError(repInfo, "Instrument");
            }
            chunk = new InstrumentChunk(this, chunkHeader, this._dstream);
            this.instrumentChunkSeen = true;
        } else if ("mext".equals(string)) {
            if (this.mpegChunkSeen) {
                this.dupChunkError(repInfo, "MPEG");
            }
            chunk = new MpegChunk(this, chunkHeader, this._dstream);
            this.mpegChunkSeen = true;
        } else if ("cart".equals(string)) {
            if (this.cartChunkSeen) {
                this.dupChunkError(repInfo, "Cart");
            }
            chunk = new CartChunk(this, chunkHeader, this._dstream);
            this.cartChunkSeen = true;
        } else if ("bext".equals(string)) {
            if (this.broadcastExtChunkSeen) {
                this.dupChunkError(repInfo, "Broadcast Audio Extension");
            }
            chunk = new BroadcastExtChunk(this, chunkHeader, this._dstream);
            this.broadcastExtChunkSeen = true;
        } else if ("levl".equals(string)) {
            if (this.peakChunkSeen) {
                this.dupChunkError(repInfo, "Peak Envelope");
            }
            chunk = new PeakEnvelopeChunk(this, chunkHeader, this._dstream);
            this.peakChunkSeen = true;
        } else if ("link".equals(string)) {
            if (this.linkChunkSeen) {
                this.dupChunkError(repInfo, "Link");
            }
            chunk = new LinkChunk(this, chunkHeader, this._dstream);
            this.linkChunkSeen = true;
        } else if ("cue ".equals(string)) {
            if (this.cueChunkSeen) {
                this.dupChunkError(repInfo, "Cue");
            }
            chunk = new CueChunk(this, chunkHeader, this._dstream);
            this.cueChunkSeen = true;
        } else {
            repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string + "' ignored", this._nByte));
        }
        if (chunk != null) {
            if (!chunk.readChunk(repInfo)) {
                return false;
            }
        } else {
            this.skipBytes(this._dstream, n, this);
        }
        if ((n & 1) != 0) {
            this.skipBytes(this._dstream, 1, this);
            --this.bytesRemaining;
        }
        return true;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo repInfo, String string) {
        repInfo.setMessage((Message)new ErrorMessage("Multiple " + string + " Chunks not permitted", this._nByte));
        repInfo.setValid(false);
    }

    public Property buildBitmaskProperty(int n, String string, String[] stringArray, String[] stringArray2) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(string, PropertyType.INTEGER, (Object)new Integer(n));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = null;
                string2 = (n & 1 << i) != 0 ? stringArray[i] : stringArray2[i];
                if (string2 == null || string2.length() <= 0) continue;
                linkedList.add(string2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return new Property(string, PropertyType.STRING, PropertyArity.LIST, linkedList);
    }
}

