/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Locale;
import javax.swing.KeyStroke;
import org.fest.swing.keystroke.KeyStrokeMapCollection;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.KeyStrokeMappingProviderPicker;
import org.fest.swing.util.Platform;
import org.fest.util.VisibleForTesting;

public class KeyStrokeMap {
    private static KeyStrokeMapCollection maps = new KeyStrokeMapCollection();

    @Deprecated
    public static void reloadFromLocale() {
        KeyStrokeMap.reloadFromSystemSettings();
    }

    public static void reloadFromSystemSettings() {
        KeyStrokeMappingProviderPicker picker = new KeyStrokeMappingProviderPicker();
        maps.clear();
        KeyStrokeMap.addKeyStrokesFrom(picker.providerFor(Platform.osFamily(), Locale.getDefault()));
    }

    @VisibleForTesting
    static void updateKeyStrokeMapCollection(KeyStrokeMapCollection c) {
        maps = c;
    }

    public static void addKeyStrokesFrom(KeyStrokeMappingProvider provider) {
        for (KeyStrokeMapping entry : provider.keyStrokeMappings()) {
            KeyStrokeMap.add(Character.valueOf(entry.character()), entry.keyStroke());
        }
    }

    private static void add(Character character, KeyStroke keyStroke) {
        maps.add(character, keyStroke);
    }

    public static void clearKeyStrokes() {
        maps.clear();
    }

    public static boolean hasKeyStrokes() {
        return !maps.isEmpty();
    }

    public static KeyStroke keyStrokeFor(char character) {
        return maps.keyStrokeFor(character);
    }

    public static char charFor(KeyStroke keyStroke) {
        Character character = maps.charFor(keyStroke);
        if (character == null) {
            character = KeyStrokeMap.charWithoutModifiersButShift(keyStroke);
        }
        if (character == null) {
            return '\uffff';
        }
        return character.charValue();
    }

    private static Character charWithoutModifiersButShift(KeyStroke keyStroke) {
        int mask = keyStroke.getModifiers() & 0xFFFFFFFE;
        return maps.charFor(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), mask));
    }

    private KeyStrokeMap() {
    }

    static {
        KeyStrokeMap.reloadFromSystemSettings();
    }
}

