/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ReadNameFilter
implements SamRecordFilter {
    private boolean includeReads = false;
    private Set<String> readNameFilterSet = new HashSet<String>();

    public ReadNameFilter(File readNameFilterFile, boolean includeReads) {
        IOUtil.assertFileIsReadable(readNameFilterFile);
        IOUtil.assertFileSizeNonZero(readNameFilterFile);
        try {
            BufferedReader in = IOUtil.openFileForBufferedReading(readNameFilterFile);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                this.readNameFilterSet.add(line.split("\\s+")[0]);
            }
            in.close();
        }
        catch (IOException e) {
            throw new SAMException(e.getMessage(), e);
        }
        this.includeReads = includeReads;
    }

    public ReadNameFilter(Set<String> readNameFilterSet, boolean includeReads) {
        this.readNameFilterSet = readNameFilterSet;
        this.includeReads = includeReads;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        return !(this.includeReads ? this.readNameFilterSet.contains(record.getReadName()) : !this.readNameFilterSet.contains(record.getReadName()));
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        return !(this.includeReads ? this.readNameFilterSet.contains(first.getReadName()) && this.readNameFilterSet.contains(second.getReadName()) : !this.readNameFilterSet.contains(first.getReadName()) && !this.readNameFilterSet.contains(second.getReadName()));
    }
}

