/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

public class DeprecatedToolChecks {
    private static Object2ObjectMap deprecatedGATKWalkers = new Object2ObjectOpenHashMap();
    private static Object2ObjectMap deprecatedGATKAnnotations;

    public static boolean isDeprecatedWalker(String walkerName) {
        return deprecatedGATKWalkers.containsKey((Object)walkerName);
    }

    public static boolean isDeprecatedAnnotation(String annotationName) {
        return deprecatedGATKAnnotations.containsKey((Object)annotationName);
    }

    public static String getWalkerDeprecationInfo(String walkerName) {
        return deprecatedGATKWalkers.get((Object)walkerName).toString();
    }

    public static String getAnnotationDeprecationInfo(String annotationName) {
        return deprecatedGATKAnnotations.get((Object)annotationName).toString();
    }

    static {
        deprecatedGATKWalkers.put((Object)"ReduceReads", (Object)"3.0 (use recommended best practices pipeline with the HaplotypeCaller)");
        deprecatedGATKWalkers.put((Object)"CountCovariates", (Object)"2.0 (use BaseRecalibrator instead; see documentation for usage)");
        deprecatedGATKWalkers.put((Object)"TableRecalibration", (Object)"2.0 (use PrintReads with -BQSR instead; see documentation for usage)");
        deprecatedGATKWalkers.put((Object)"AlignmentWalker", (Object)"2.2 (no replacement)");
        deprecatedGATKWalkers.put((Object)"CountBestAlignments", (Object)"2.2 (no replacement)");
        deprecatedGATKWalkers.put((Object)"SomaticIndelDetector", (Object)"2.0 (replaced by the standalone tool Indelocator; see Cancer Tools documentation)");
        deprecatedGATKAnnotations = new Object2ObjectOpenHashMap();
        deprecatedGATKAnnotations.put((Object)"DepthOfCoverage", (Object)"2.4 (renamed to Coverage)");
    }
}

