/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.lang.reflect.Field;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.reference.TypeRef;
import org.fest.reflect.util.Accessibles;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker<T> {
    private final Object target;
    private final Field field;
    private final boolean accessible;

    static <T> Invoker<T> newInvoker(String fieldName, TypeRef<T> expectedType, Object target) {
        return Invoker.createInvoker(fieldName, expectedType.rawType(), target);
    }

    static <T> Invoker<T> newInvoker(String fieldName, Class<T> expectedType, Object target) {
        return Invoker.createInvoker(fieldName, expectedType, target);
    }

    private static <T> Invoker<T> createInvoker(String fieldName, Class<?> expectedType, Object target) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        Field field = Invoker.lookupInClassHierarchy(fieldName, Invoker.typeOf(target));
        Invoker.verifyCorrectType(field, expectedType);
        return new Invoker<T>(target, field);
    }

    private static Class<?> typeOf(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }

    private static Field lookupInClassHierarchy(String fieldName, Class<?> declaringType) {
        Field field = null;
        for (Class<?> target = declaringType; target != null && (field = Invoker.field(fieldName, target)) == null; target = target.getSuperclass()) {
        }
        if (field != null) {
            return field;
        }
        throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find field ", Strings.quote((String)fieldName), " in ", declaringType.getName()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyCorrectType(Field field, Class<?> expectedType) {
        boolean isAccessible = field.isAccessible();
        try {
            Accessibles.makeAccessible(field);
            Class<?> actualType = field.getType();
            if (!expectedType.isAssignableFrom(actualType)) {
                throw Invoker.incorrectFieldType(field, actualType, expectedType);
            }
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(field, isAccessible);
        }
    }

    private Invoker(Object target, Field field) {
        this.target = target;
        this.field = field;
        this.accessible = field.isAccessible();
    }

    private static Field field(String fieldName, Class<?> declaringType) {
        try {
            return declaringType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static ReflectionError incorrectFieldType(Field field, Class<?> actual, Class<?> expected) {
        String fieldTypeName = field.getDeclaringClass().getName();
        String message = Strings.concat((Object[])new Object[]{"The type of the field ", Strings.quote((String)field.getName()), " in ", fieldTypeName, " should be <", expected.getName(), "> but was <", actual.getName(), ">"});
        throw new ReflectionError(message);
    }

    public void set(T value) {
        try {
            Accessibles.setAccessible(this.field, true);
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to update the value in field ", Strings.quote((String)this.field.getName())}), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, this.accessible);
        }
    }

    public T get() {
        try {
            Accessibles.setAccessible(this.field, true);
            Object object = this.field.get(this.target);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to obtain the value in field " + Strings.quote((String)this.field.getName())}), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, this.accessible);
        }
    }

    public Field info() {
        return this.field;
    }
}

