/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.SyncProvider;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;

class OracleWebRowSetXmlWriterImpl
implements OracleWebRowSetXmlWriter {
    private Writer xmlWriter;
    private Stack xmlTagStack;
    private static final String WEBROWSET_ELEMENT = "webRowSet";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String METADATA_ELEMENT = "metadata";
    private static final String DATA_ELEMENT = "data";
    private static final String PROPERTY_COMMAND = "command";
    private static final String PROPERTY_CONCURRENCY = "concurrency";
    private static final String PROPERTY_DATASOURCE = "datasource";
    private static final String PROPERTY_ESCAPEPROCESSING = "escape-processing";
    private static final String PROPERTY_FETCHDIRECTION = "fetch-direction";
    private static final String PROPERTY_FETCHSIZE = "fetch-size";
    private static final String PROPERTY_ISOLATIONLEVEL = "isolation-level";
    private static final String PROPERTY_KEYCOLUMNS = "key-columns";
    private static final String PROPERTY_MAP = "map";
    private static final String PROPERTY_MAXFIELDSIZE = "max-field-size";
    private static final String PROPERTY_MAXROWS = "max-rows";
    private static final String PROPERTY_QUERYTIMEOUT = "query-timeout";
    private static final String PROPERTY_READONLY = "read-only";
    private static final String PROPERTY_ROWSETTYPE = "rowset-type";
    private static final String PROPERTY_SHOWDELETED = "show-deleted";
    private static final String PROPERTY_TABLENAME = "table-name";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_SYNCPROVIDER = "sync-provider";
    private static final String PROPERTY_NULL = "null";
    private static final String PROPERTY_KC_COLUMN = "column";
    private static final String PROPERTY_MAP_TYPE = "type";
    private static final String PROPERTY_MAP_CLASS = "class";
    private static final String PROPERTY_S_PROVIDERNAME = "sync-provider-name";
    private static final String PROPERTY_S_PROVIDERVENDOR = "sync-provider-vendor";
    private static final String PROPERTY_S_PROVIDERVERSION = "sync-provider-version";
    private static final String PROPERTY_S_PROVIDERGRADE = "sync-provider-grade";
    private static final String PROPERTY_S_DATASOURCELOCK = "data-source-lock";
    private static final String METADATA_COLUMNCOUNT = "column-count";
    private static final String METADATA_COLUMNDEFINITION = "column-definition";
    private static final String METADATA_COLUMNINDEX = "column-index";
    private static final String METADATA_AUTOINCREMENT = "auto-increment";
    private static final String METADATA_CASESENSITIVE = "case-sensitive";
    private static final String METADATA_CURRENCY = "currency";
    private static final String METADATA_NULLABLE = "nullable";
    private static final String METADATA_SIGNED = "signed";
    private static final String METADATA_SEARCHABLE = "searchable";
    private static final String METADATA_COLUMNDISPLAYSIZE = "column-display-size";
    private static final String METADATA_COLUMNLABEL = "column-label";
    private static final String METADATA_COLUMNNAME = "column-name";
    private static final String METADATA_SCHEMANAME = "schema-name";
    private static final String METADATA_COLUMNPRECISION = "column-precision";
    private static final String METADATA_COLUMNSCALE = "column-scale";
    private static final String METADATA_TABLENAME = "table-name";
    private static final String METADATA_CATALOGNAME = "catalog-name";
    private static final String METADATA_COLUMNTYPE = "column-type";
    private static final String METADATA_COLUMNTYPENAME = "column-type-name";
    private static final String METADATA_NULL = "null";
    private static final String DATA_CURRENTROW = "currentRow";
    private static final String DATA_INSERTROW = "insertRow";
    private static final String DATA_DELETEROW = "deleteRow";
    private static final String DATA_MODIFYROW = "modifyRow";
    private static final String DATA_COLUMNVALUE = "columnValue";
    private static final String DATA_UPDATEVALUE = "updateValue";
    private static final String DATA_NULL = "null";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    OracleWebRowSetXmlWriterImpl() {
    }

    @Override
    public void writeXML(WebRowSet webRowSet, Writer writer) throws SQLException {
        if (!(webRowSet instanceof OracleWebRowSet)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 359);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.xmlTagStack = new Stack();
        this.xmlWriter = writer;
        this.writeRowSet((OracleWebRowSet)webRowSet);
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        return false;
    }

    private void writeRowSet(OracleWebRowSet oracleWebRowSet) throws SQLException {
        try {
            this.writeHeaderAndStartWebRowSetElement();
            this.writeProperties(oracleWebRowSet);
            this.writeMetaData(oracleWebRowSet);
            this.writeData(oracleWebRowSet);
            this.endWebRowSetElement();
        }
        catch (IOException iOException) {
            throw new SQLException("IOException: " + iOException.getMessage());
        }
    }

    private void writeHeaderAndStartWebRowSetElement() throws IOException {
        this.xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.xmlWriter.write("\n");
        this.setCurrentTag(WEBROWSET_ELEMENT);
        this.xmlWriter.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\"\n");
        this.xmlWriter.write("           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        this.xmlWriter.write("           xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
        this.xmlWriter.write("http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
        this.xmlWriter.write("\">\n");
    }

    private void endWebRowSetElement() throws IOException {
        this.endTag(WEBROWSET_ELEMENT);
    }

    private void startElement(String string) throws IOException {
        this.startTag(string);
        this.xmlWriter.write("\n");
    }

    private void endElement(String string) throws IOException {
        this.writeIndent(this.xmlTagStack.size());
        this.endTag(string);
    }

    private void endElement() throws IOException {
        this.writeIndent(this.xmlTagStack.size());
        String string = this.getCurrentTag();
        this.xmlWriter.write("</" + string + ">\n");
        this.xmlWriter.flush();
    }

    private void startTag(String string) throws IOException {
        this.setCurrentTag(string);
        this.writeIndent(this.xmlTagStack.size());
        this.xmlWriter.write("<" + string + ">");
    }

    private void endTag(String string) throws IOException {
        String string2 = this.getCurrentTag();
        if (string.equals(string2)) {
            this.xmlWriter.write("</" + string2 + ">\n");
        }
        this.xmlWriter.flush();
    }

    private void setCurrentTag(String string) {
        this.xmlTagStack.push(string);
    }

    private String getCurrentTag() {
        return (String)this.xmlTagStack.pop();
    }

    private void writeEmptyElement(String string) throws IOException {
        this.xmlWriter.write("<" + string + "/>");
    }

    private void writeProperties(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.startElement(PROPERTIES_ELEMENT);
        try {
            this.writeElementString(PROPERTY_COMMAND, oracleWebRowSet.getCommand());
            this.writeElementInteger(PROPERTY_CONCURRENCY, oracleWebRowSet.getConcurrency());
            this.writeElementString(PROPERTY_DATASOURCE, oracleWebRowSet.getDataSourceName());
            this.writeElementBoolean(PROPERTY_ESCAPEPROCESSING, oracleWebRowSet.getEscapeProcessing());
            this.writeElementInteger(PROPERTY_FETCHDIRECTION, oracleWebRowSet.getFetchDirection());
            this.writeElementInteger(PROPERTY_FETCHSIZE, oracleWebRowSet.getFetchSize());
            this.writeElementInteger(PROPERTY_ISOLATIONLEVEL, oracleWebRowSet.getTransactionIsolation());
            this.startElement(PROPERTY_KEYCOLUMNS);
            int[] nArray = oracleWebRowSet.getKeyColumns();
            for (int i2 = 0; nArray != null && i2 < nArray.length; ++i2) {
                this.writeElementInteger(PROPERTY_KC_COLUMN, nArray[i2]);
            }
            this.endElement(PROPERTY_KEYCOLUMNS);
            this.startElement(PROPERTY_MAP);
            Map map = oracleWebRowSet.getTypeMap();
            if (map != null) {
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    this.writeElementString(PROPERTY_MAP_TYPE, (String)entry.getKey());
                    this.writeElementString(PROPERTY_MAP_CLASS, ((Class)entry.getValue()).getName());
                }
            }
            this.endElement(PROPERTY_MAP);
            this.writeElementInteger(PROPERTY_MAXFIELDSIZE, oracleWebRowSet.getMaxFieldSize());
            this.writeElementInteger(PROPERTY_MAXROWS, oracleWebRowSet.getMaxRows());
            this.writeElementInteger(PROPERTY_QUERYTIMEOUT, oracleWebRowSet.getQueryTimeout());
            this.writeElementBoolean(PROPERTY_READONLY, oracleWebRowSet.isReadOnly());
            this.writeElementInteger(PROPERTY_ROWSETTYPE, oracleWebRowSet.getType());
            this.writeElementBoolean(PROPERTY_SHOWDELETED, oracleWebRowSet.getShowDeleted());
            this.writeElementString("table-name", oracleWebRowSet.getTableName());
            this.writeElementString(PROPERTY_URL, oracleWebRowSet.getUrl());
            this.startElement(PROPERTY_SYNCPROVIDER);
            SyncProvider syncProvider = oracleWebRowSet.getSyncProvider();
            this.writeElementString(PROPERTY_S_PROVIDERNAME, syncProvider.getProviderID());
            this.writeElementString(PROPERTY_S_PROVIDERVENDOR, syncProvider.getVendor());
            this.writeElementString(PROPERTY_S_PROVIDERVERSION, syncProvider.getVersion());
            this.writeElementInteger(PROPERTY_S_PROVIDERGRADE, syncProvider.getProviderGrade());
            this.writeElementInteger(PROPERTY_S_DATASOURCELOCK, syncProvider.getDataSourceLock());
            this.endElement(PROPERTY_SYNCPROVIDER);
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endElement(PROPERTIES_ELEMENT);
    }

    private void writeMetaData(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.startElement(METADATA_ELEMENT);
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.writeElementInteger(METADATA_COLUMNCOUNT, n2);
            for (int i2 = 1; i2 <= n2; ++i2) {
                this.startElement(METADATA_COLUMNDEFINITION);
                this.writeElementInteger(METADATA_COLUMNINDEX, i2);
                this.writeElementBoolean(METADATA_AUTOINCREMENT, resultSetMetaData.isAutoIncrement(i2));
                this.writeElementBoolean(METADATA_CASESENSITIVE, resultSetMetaData.isCaseSensitive(i2));
                this.writeElementBoolean(METADATA_CURRENCY, resultSetMetaData.isCurrency(i2));
                this.writeElementInteger(METADATA_NULLABLE, resultSetMetaData.isNullable(i2));
                this.writeElementBoolean(METADATA_SIGNED, resultSetMetaData.isSigned(i2));
                this.writeElementBoolean(METADATA_SEARCHABLE, resultSetMetaData.isSearchable(i2));
                this.writeElementInteger(METADATA_COLUMNDISPLAYSIZE, resultSetMetaData.getColumnDisplaySize(i2));
                this.writeElementString(METADATA_COLUMNLABEL, resultSetMetaData.getColumnLabel(i2));
                this.writeElementString(METADATA_COLUMNNAME, resultSetMetaData.getColumnName(i2));
                this.writeElementString(METADATA_SCHEMANAME, resultSetMetaData.getSchemaName(i2));
                this.writeElementInteger(METADATA_COLUMNPRECISION, resultSetMetaData.getPrecision(i2));
                this.writeElementInteger(METADATA_COLUMNSCALE, resultSetMetaData.getScale(i2));
                this.writeElementString("table-name", resultSetMetaData.getTableName(i2));
                this.writeElementString(METADATA_CATALOGNAME, resultSetMetaData.getCatalogName(i2));
                this.writeElementInteger(METADATA_COLUMNTYPE, resultSetMetaData.getColumnType(i2));
                this.writeElementString(METADATA_COLUMNTYPENAME, resultSetMetaData.getColumnTypeName(i2));
                this.endElement(METADATA_COLUMNDEFINITION);
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endElement(METADATA_ELEMENT);
    }

    private void writeElementBoolean(String string, boolean bl) throws IOException {
        this.startTag(string);
        this.writeBoolean(bl);
        this.endTag(string);
    }

    private void writeElementInteger(String string, int n2) throws IOException {
        this.startTag(string);
        this.writeInteger(n2);
        this.endTag(string);
    }

    private void writeElementString(String string, String string2) throws IOException {
        this.startTag(string);
        this.writeString(string2);
        this.endTag(string);
    }

    private void writeData(OracleWebRowSet oracleWebRowSet) throws IOException {
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.startElement(DATA_ELEMENT);
            oracleWebRowSet.beforeFirst();
            oracleWebRowSet.setShowDeleted(true);
            while (oracleWebRowSet.next()) {
                if (oracleWebRowSet.rowDeleted() && oracleWebRowSet.rowInserted()) {
                    this.startElement(DATA_MODIFYROW);
                } else if (oracleWebRowSet.rowDeleted()) {
                    this.startElement(DATA_DELETEROW);
                } else if (oracleWebRowSet.rowInserted()) {
                    this.startElement(DATA_INSERTROW);
                } else {
                    this.startElement(DATA_CURRENTROW);
                }
                for (int i2 = 1; i2 <= n2; ++i2) {
                    if (oracleWebRowSet.columnUpdated(i2)) {
                        ResultSet resultSet = oracleWebRowSet.getOriginalRow();
                        resultSet.next();
                        this.startTag(DATA_COLUMNVALUE);
                        this.writeValue(i2, (RowSet)resultSet);
                        this.endTag(DATA_COLUMNVALUE);
                        this.startTag(DATA_UPDATEVALUE);
                        this.writeValue(i2, oracleWebRowSet);
                        this.endTag(DATA_UPDATEVALUE);
                        continue;
                    }
                    this.startTag(DATA_COLUMNVALUE);
                    this.writeValue(i2, oracleWebRowSet);
                    this.endTag(DATA_COLUMNVALUE);
                }
                this.endElement();
            }
            this.endElement(DATA_ELEMENT);
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
    }

    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.xmlWriter.write(bigDecimal.toString());
        } else {
            this.writeEmptyElement("null");
        }
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.xmlWriter.write(Boolean.valueOf(bl).toString());
    }

    private void writeDouble(double d2) throws IOException {
        this.xmlWriter.write(Double.toString(d2));
    }

    private void writeFloat(float f2) throws IOException {
        this.xmlWriter.write(Float.toString(f2));
    }

    private void writeInteger(int n2) throws IOException {
        this.xmlWriter.write(Integer.toString(n2));
    }

    private void writeLong(long l2) throws IOException {
        this.xmlWriter.write(Long.toString(l2));
    }

    private void writeNull() throws IOException {
        this.writeEmptyElement("null");
    }

    private void writeShort(short s2) throws IOException {
        this.xmlWriter.write(Short.toString(s2));
    }

    private void writeBytes(byte[] byArray) throws IOException {
        this.xmlWriter.write(new String(byArray));
    }

    private void writeString(String string) throws IOException {
        if (string != null) {
            this.xmlWriter.write(string);
        } else {
            this.xmlWriter.write("");
        }
    }

    private void writeIndent(int n2) throws IOException {
        for (int i2 = 1; i2 < n2; ++i2) {
            this.xmlWriter.write("  ");
        }
    }

    private void writeValue(int n2, RowSet rowSet) throws IOException {
        try {
            int n3 = rowSet.getMetaData().getColumnType(n2);
            switch (n3) {
                case -7: 
                case 5: {
                    short s2 = rowSet.getShort(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeShort(s2);
                    break;
                }
                case 4: {
                    int n4 = rowSet.getInt(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeInteger(n4);
                    break;
                }
                case -5: {
                    long l2 = rowSet.getLong(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(l2);
                    break;
                }
                case 6: 
                case 7: {
                    float f2 = rowSet.getFloat(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeFloat(f2);
                    break;
                }
                case 8: {
                    double d2 = rowSet.getDouble(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeDouble(d2);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = rowSet.getBigDecimal(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBigDecimal(bigDecimal);
                    break;
                }
                case 91: {
                    Date date = rowSet.getDate(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(date.getTime());
                    break;
                }
                case 92: {
                    Time time = rowSet.getTime(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(time.getTime());
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowSet.getTimestamp(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(timestamp.getTime());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    byte[] byArray = rowSet.getBytes(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBytes(byArray);
                    break;
                }
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    String string = rowSet.getString(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeString(string);
                    break;
                }
                default: {
                    throw new SQLException("The type " + n3 + " is not supported currently.");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("Failed to writeValue: " + sQLException.getMessage());
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

