
/*
 * This tool generates updated hwdb data for Intel GPUs, so we
 * get the same name in udev as we do in Mesa.
 */

#include <locale.h>
#include <glib.h>

typedef struct {
	int vid;
	int pid;
	const char *name;
} pci_id;

/* Intel drivers */
#define CHIPSET(x, y, z) { 0x8086, x, z },
pci_id i965_pci_ids[] = {
#include "/home/hadess/Projects/jhbuild/mesa/include/pci_ids/i965_pci_ids.h"
	{ },
};
pci_id i915_pci_ids[] = {
#include "/home/hadess/Projects/jhbuild/mesa/include/pci_ids/i915_pci_ids.h"
	{},
};

static void
print_table (pci_id *table)
{
	guint i;

	for (i = 0; table[i].vid != 0; i++) {
		const char *name;

		name = table[i].name;
		g_print ("pci:v%08xd%08x*\n", table[i].vid, table[i].pid);

		/* Quirk */
		if (g_str_equal ("Mobile Intel® GM45 Express Chipset", name))
			name = "Intel(R) Mobile GM45 Express Chipset";

		if (!g_str_has_prefix (name, "Intel(R) "))
			g_error ("Unhandled name %s", name);
		g_print (" SWITCHEROO_CONTROL_VENDOR_NAME=Intel(R)\n");
		g_print (" SWITCHEROO_CONTROL_PRODUCT_NAME=%s\n", name + strlen ("Intel(R) "));
		g_print ("\n");
	}
}

int main (int argc, char **argv)
{
	setlocale (LC_ALL, "");

	g_print ("# Generated by a helper script in switcheroo-control\n");
	g_print ("# See https://gitlab.freedesktop.org/hadess/switcheroo-control/\n\n");

	print_table (i965_pci_ids);
	print_table (i915_pci_ids);
	return 0;
}
