.\"
.\" nfsd(7) - The nfsd filesystem
.\"
.\" Copyright (C) 2003 Neil Brown <neilb@cse.unsw.edu.au>
.\" Licensed for public use under the terms of the FSF
.\" General Public License (GPL) version 2.
.TH nfsd 7 "3 July 2003"
.SH NAME
nfsd \- special filesystem for controlling Linux NFS server
.SH SYNPOSIS
.B "mount -t nfsd nfsd /proc/fs/nfsd"
.SH DESCRIPTION
The
.B nfsd
filesystem is a special filesystem which provides access to the Linux
NFS server.  Writing to files in this filesystem can affect the server.
Reading from them can provide information about the server.
.P
As well as this filesystem, there are a collection of files in the
.B procfs
filesystem (normally mounted at
.BR /proc )
which are used to control the NFS server.
This manual page describes all of these files.
.P
The
.I exportfs
and
.I mountd
programs (part of the nfs-utils package) expect to find this
filesystem mounted at
.B /proc/fs/nfsd
or
.BR /proc/fs/nfs .
.SH DETAILS
Files in the
.B nfsd
filesystem include:
.TP
.B exports
This file contains a list of filesystems that are currently exported
and clients that each filesystem is exported to, together with a list
of export options for that client/filesystem pair.  This is similar
to the
.B /proc/fs/nfs/exports
file in 2.4.
One difference is that a client doesn't necessarily correspond to just
one host.  It can respond to a large collection of hosts that are
being treated identically.

Each line of the file contains a path name, a client name, and a
number of options in parentheses.  Any space, tab, newline or
back-slash character in the path name or client name will be replaced
by a backslash followed by the octal ASCII code for that character.

.TP
.B threads
This file represents the number of
.B nfsd
thread currently running.  Reading it will show the number of
threads.  Writing an ASCII decimal number will cause the number of
threads to be changed (increased or decreased as necessary) to achieve
that number.

.TP
.B filehandle
This is a somewhat unusual file  in that what is read from it depends
on what was just written to it.  It provides a transactional interface
where a program can open the file, write a request, and read a
response.  If two separate programs open, write, and read at the same
time, their requests will not be mixed up.

The request written to
.B filehandle
should be a client name, a path name, and a number of bytes.  This
should be followed by a newline, with white-space separating the
fields, and octal quoting of special characters.

On writing this, the program will be able to read back a filehandle
for that path as exported to the given client.  The filehandle's length
will be at most the number of bytes given.

The filehandle will be represented in hex with a leading '\ex'.

.TP
.B clients/
This directory contains a subdirectory for each NFSv4 client.  Each file
under that subdirectory gives some details about the client in YAML
format.  In addition, writing "expire\\n" to the
.B ctl
file will force the server to immediately revoke all state held by that
client.

.PP
The directory
.B /proc/net/rpc
in the
.B procfs
filesystem contains a number of files and directories.
The files contain statistics that can be display using the
.I nfsstat
program.
The directories contain information about various caches that the NFS
server maintains to keep track of access permissions that different
clients have for different filesystems.
The caches are:

.TP
.B auth.unix.ip
This cache contains a mapping from IP address to the name of the
authentication domain that the ipaddress should be treated as part of.

.TP
.B nfsd.export
This cache contains a mapping from directory and domain to export
options.

.TP
.B nfsd.fh
This cache contains a mapping from domain and a filesystem identifier
to a directory.   The filesystem identifier is stored in the
filehandles and consists of a number indicating the type of identifier
and a number of hex bytes indicating the content of the identifier.

.PP
Each directory representing a cache can hold from 1 to 3 files.  They
are:
.TP
.B flush
When a number of seconds since epoch (1 Jan 1970) is written to this
file, all entries in the cache that were last updated before that file
become invalidated and will be flushed out.  Writing a time in the
future (in seconds since epoch) will flush
everything.  This is the only file that will always be present.

.TP
.B content
This file, if present, contains a textual representation of ever entry
in the cache, one per line.  If an entry is still in the cache
(because it is actively being used) but has expired or is otherwise
invalid, it will be presented as a comment (with a leading hash
character).

.TP
.B channel
This file, if present, acts a channel for request from the kernel-based
nfs server to be passed to a user-space program for handling.

When the kernel needs some information which isn't in the cache, it
makes a line appear in the
.B channel
file giving the key for the information.  A user-space program should
read this, find the answer, and write a line containing the key, an
expiry time, and the content.
For example the kernel might make
.ti +5
nfsd 127.0.0.1
.br
appear in the
.B auth.unix.ip/content
file.  The user-space program might then write
.ti +5
nfsd 127.0.0.1 1057206953 localhost
.br
to indicate that 127.0.0.1 should map to localhost, at least for now.

If the program uses select(2) or poll(2) to discover if it can read
from the
.B channel
then it will never see and end-of-file but when all requests have been
answered, it will block until another request appears.

.PP
In the
.B /proc
filesystem there are 4 files that can be used to enabled extra tracing
of nfsd and related code.  They are:
.in +5
.B /proc/sys/sunrpc/nfs_debug
.br
.B /proc/sys/sunrpc/nfsd_debug
.br
.B /proc/sys/sunrpc/nlm_debug
.br
.B /proc/sys/sunrpc/rpc_debug
.br
.in -5
They control tracing for the NFS client, the NFS server, the Network
Lock Manager (lockd) and the underlying RPC layer respectively.
Decimal numbers can be read from or written to these files.  Each
number represents a bit-pattern where bits that are set cause certain
classes of tracing to be enabled.  Consult the kernel header files to
find out what number correspond to what tracing.

.SH NOTES
This file system is only available in Linux 2.6 and later series
kernels (and in the later parts of the 2.5 development series leading
up to 2.6).  This man page does not apply to 2.4 and earlier.
.P
Previously the nfsctl systemcall was used for communication between nfsd
and user utilities.  That systemcall was removed in kernel version 3.1.
Older nfs-utils versions were able to fall back to nfsctl if necessary;
that was removed from nfs-utils 1.3.5.

.SH SEE ALSO
.BR nfsd (8),
.BR rpc.nfsd (8),
.BR exports (5),
.BR nfsstat (8),
.BR mountd (8)
.BR exportfs (8).

.SH AUTHOR
NeilBrown
