/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw.symbol;

import com.wombatinvasion.pmwikidraw.symbol.MultiLanguageString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import qdxml.DocHandler;

public class SymbolPackage
implements DocHandler {
    private String author = "";
    private String creationDate = "";
    private MultiLanguageString name = new MultiLanguageString();
    private MultiLanguageString description = new MultiLanguageString();
    Stack stack = null;
    private List symbolGroups = new ArrayList();
    SymbolGroup defaultGroup = new SymbolGroup();
    SymbolGroup activeSymbolGroup = null;
    Symbol currentSymbol = null;

    public SymbolPackage() {
        this.symbolGroups.clear();
    }

    public void startElement(String string, Hashtable hashtable) throws Exception {
        String string2;
        block10: {
            Iterator iterator;
            block8: {
                Symbol symbol;
                block9: {
                    iterator = hashtable.keySet().iterator();
                    string2 = string.toLowerCase();
                    if (this.stack.size() <= 0) break block8;
                    if (!string2.equals("symbol-group")) break block9;
                    this.activeSymbolGroup = new SymbolGroup();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        String string4 = (String)hashtable.get(string3);
                        if (!string3.equals("name")) continue;
                        this.activeSymbolGroup.name.addString(null, string4);
                    }
                    this.symbolGroups.add(this.activeSymbolGroup);
                    break block10;
                }
                if (!string2.equals("symbol")) break block10;
                this.currentSymbol = symbol = new Symbol();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    String string6 = (String)hashtable.get(string5);
                    if (string5.equals("location")) {
                        symbol.location = string6;
                        continue;
                    }
                    if (!string5.equals("name")) continue;
                    symbol.name.addString(null, string6);
                }
                if (this.activeSymbolGroup != null) {
                    this.activeSymbolGroup.symbols.add(symbol);
                } else {
                    this.defaultGroup.symbols.add(symbol);
                }
                break block10;
            }
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                String string8 = (String)hashtable.get(string7);
                if (string7.toLowerCase().equals("author")) {
                    this.author = string8;
                    continue;
                }
                if (string7.toLowerCase().equals("creation-date")) {
                    this.creationDate = string8;
                    continue;
                }
                if (!string7.toLowerCase().equals("name")) continue;
                this.name.addString(null, string8);
            }
        }
        this.stack.push(new XmlNode(string2, hashtable));
    }

    public void endElement(String string) throws Exception {
        this.stack.pop();
        String string2 = string.toLowerCase();
        if (string2.equals("symbol-group")) {
            this.activeSymbolGroup = null;
        } else if (string2.equals("symbol-group")) {
            this.currentSymbol = null;
        }
    }

    public void startDocument() throws Exception {
        this.stack = new Stack();
    }

    public void endDocument() throws Exception {
        this.stack = null;
        if (this.defaultGroup.symbols.size() > 0) {
            this.defaultGroup.name.addString(null, "Default");
            this.symbolGroups.add(0, this.defaultGroup);
        }
    }

    public void text(String string) throws Exception {
        if (this.stack.size() > 0) {
            XmlNode xmlNode = (XmlNode)this.stack.peek();
            if (xmlNode.tag.equals("package-name")) {
                this.name.addString((String)xmlNode.attr.get("lang"), string);
            } else if (xmlNode.tag.equals("package-description")) {
                this.description.addString((String)xmlNode.attr.get("lang"), string);
            } else if (xmlNode.tag.equals("symbol-group-name")) {
                if (this.activeSymbolGroup != null) {
                    this.activeSymbolGroup.name.addString((String)xmlNode.attr.get("lang"), string);
                } else {
                    System.err.println("Error processing manifest document, 'symbol-group-name' in invalid place.");
                }
            } else if (xmlNode.tag.equals("symbol-group-description")) {
                if (this.activeSymbolGroup != null) {
                    this.activeSymbolGroup.description.addString((String)xmlNode.attr.get("lang"), string);
                } else {
                    System.err.println("Error processing manifest document, 'symbol-group-description' in invalid place.");
                }
            } else if (xmlNode.tag.equals("symbol-name")) {
                if (this.currentSymbol != null) {
                    this.currentSymbol.name.addString((String)xmlNode.attr.get("lang"), string);
                } else {
                    System.err.println("Error processing manifest document, 'symbol-name' in invalid place.");
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Package Name:" + this.name + "\nCreated by:" + this.author + "\nCreated at:" + this.creationDate);
        for (int i = 0; i < this.symbolGroups.size(); ++i) {
            SymbolGroup symbolGroup = (SymbolGroup)this.symbolGroups.get(i);
            stringBuffer.append("\n" + symbolGroup.name + "; " + symbolGroup.description + " ->");
            for (int j = 0; j < symbolGroup.symbols.size(); ++j) {
                Symbol symbol = (Symbol)symbolGroup.symbols.get(j);
                stringBuffer.append("\n\t" + symbol.name + "; " + symbol.location);
            }
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name.getLocaleString();
    }

    public int getSymbolGroupCount() {
        return this.symbolGroups.size();
    }

    public List getSymbolGroups() {
        return this.symbolGroups;
    }

    private class SymbolPackageDefinition {
        HashSet names = new HashSet();
        HashSet descriptions = new HashSet();
        String author;
        String creationDate;

        private SymbolPackageDefinition() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.names.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next() + ", ");
            }
            return stringBuffer.toString();
        }
    }

    public class SymbolGroup {
        public MultiLanguageString name = new MultiLanguageString();
        public MultiLanguageString description = new MultiLanguageString();
        public List symbols = new ArrayList();
    }

    public class Symbol {
        public String location;
        public MultiLanguageString name = new MultiLanguageString();
    }

    private class XmlNode {
        String tag;
        Hashtable attr;

        public XmlNode(String string, Hashtable hashtable) {
            this.tag = string;
            this.attr = hashtable;
        }
    }
}

