/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public class SelectionColorIcon
extends ImageIcon {
    private DrawingEditor editor;
    private AttributeKey<Color> key;
    private Shape colorShape;

    public SelectionColorIcon(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, URL uRL, Shape shape) {
        super(uRL);
        this.editor = drawingEditor;
        this.key = attributeKey;
        this.colorShape = shape;
    }

    public SelectionColorIcon(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, Image image, Shape shape) {
        super(image);
        this.editor = drawingEditor;
        this.key = attributeKey;
        this.colorShape = shape;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        DrawingView drawingView = this.editor.getActiveView();
        Color color = drawingView != null && drawingView.getSelectedFigures().size() == 1 ? drawingView.getSelectedFigures().iterator().next().get(this.key) : this.key.get(this.editor.getDefaultAttributes());
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.translate(n, n2);
            graphics2D.fill(this.colorShape);
            graphics2D.translate(-n, -n2);
        }
    }
}

