/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.odftoolkit.odfdom.dom.element.draw.DrawLayerSetElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfOfficeMasterStyles
extends OfficeMasterStylesElement {
    private static final long serialVersionUID = 6598785919980862801L;
    private DrawLayerSetElement mLayerSet;
    private StyleHandoutMasterElement mHandoutMaster;
    private HashMap<String, StyleMasterPageElement> mMasterPages;

    public OdfOfficeMasterStyles(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public StyleHandoutMasterElement getHandoutMaster() {
        return this.mHandoutMaster;
    }

    public DrawLayerSetElement getLayerSet() {
        return this.mLayerSet;
    }

    public StyleMasterPageElement getMasterPage(String name) {
        if (this.mMasterPages != null) {
            return this.mMasterPages.get(name);
        }
        return null;
    }

    public Iterator<StyleMasterPageElement> getMasterPages() {
        if (this.mMasterPages != null) {
            return this.mMasterPages.values().iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof DrawLayerSetElement) {
            this.mLayerSet = (DrawLayerSetElement)node;
        } else if (node instanceof StyleHandoutMasterElement) {
            this.mHandoutMaster = (StyleHandoutMasterElement)node;
        } else if (node instanceof StyleMasterPageElement) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)node;
            if (this.mMasterPages == null) {
                this.mMasterPages = new HashMap();
            }
            this.mMasterPages.put(masterPage.getStyleNameAttribute(), masterPage);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof DrawLayerSetElement) {
            if (this.mLayerSet == (DrawLayerSetElement)node) {
                this.mLayerSet = null;
            }
        } else if (node instanceof StyleHandoutMasterElement) {
            if (this.mHandoutMaster == (StyleHandoutMasterElement)node) {
                this.mHandoutMaster = null;
            }
        } else if (node instanceof StyleMasterPageElement && this.mMasterPages != null) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)node;
            this.mMasterPages.remove(masterPage.getStyleNameAttribute());
        }
    }
}

