; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S -data-layout="E-p:64:64:64-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128" | FileCheck %s -check-prefixes=ALL,CHECK
; RUN: opt < %s -instcombine -S -data-layout="E-p:32:32:32-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128" | FileCheck %s -check-prefixes=ALL,P32
; RUN: opt < %s -instcombine -S | FileCheck %s -check-prefixes=ALL,NODL

declare void @use(...)

@int = global i32 zeroinitializer

; Zero byte allocas should be merged if they can't be deleted.
define void @test() {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[X:%.*]] = alloca [0 x i32], align 4
; CHECK-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; CHECK-NEXT:    [[Y1_SUB:%.*]] = getelementptr inbounds [0 x i32], [0 x i32]* [[X]], i64 0, i64 0
; CHECK-NEXT:    call void (...) @use(i32* nonnull [[Y1_SUB]])
; CHECK-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; CHECK-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; CHECK-NEXT:    ret void
;
; P32-LABEL: @test(
; P32-NEXT:    [[X:%.*]] = alloca [0 x i32], align 4
; P32-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; P32-NEXT:    [[Y1_SUB:%.*]] = getelementptr inbounds [0 x i32], [0 x i32]* [[X]], i32 0, i32 0
; P32-NEXT:    call void (...) @use(i32* nonnull [[Y1_SUB]])
; P32-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; P32-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; P32-NEXT:    ret void
;
; NODL-LABEL: @test(
; NODL-NEXT:    [[X:%.*]] = alloca [0 x i32], align 8
; NODL-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; NODL-NEXT:    [[Y1_SUB:%.*]] = getelementptr inbounds [0 x i32], [0 x i32]* [[X]], i64 0, i64 0
; NODL-NEXT:    call void (...) @use(i32* nonnull [[Y1_SUB]])
; NODL-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; NODL-NEXT:    call void (...) @use([0 x i32]* nonnull [[X]])
; NODL-NEXT:    ret void
;
  %X = alloca [0 x i32]           ; <[0 x i32]*> [#uses=1]
  call void (...) @use( [0 x i32]* %X )
  %Y = alloca i32, i32 0          ; <i32*> [#uses=1]
  call void (...) @use( i32* %Y )
  %Z = alloca {  }                ; <{  }*> [#uses=1]
  call void (...) @use( {  }* %Z )
  %size = load i32, i32* @int
  %A = alloca {{}}, i32 %size
  call void (...) @use( {{}}* %A )
  ret void
}

; Zero byte allocas should be deleted.
define void @test2() {
; ALL-LABEL: @test2(
; ALL-NEXT:    ret void
;
  %A = alloca i32         ; <i32*> [#uses=1]
  store i32 123, i32* %A
  ret void
}

; Zero byte allocas should be deleted.
define void @test3() {
; ALL-LABEL: @test3(
; ALL-NEXT:    ret void
;
  %A = alloca { i32 }             ; <{ i32 }*> [#uses=1]
  %B = getelementptr { i32 }, { i32 }* %A, i32 0, i32 0            ; <i32*> [#uses=1]
  store i32 123, i32* %B
  ret void
}

define i32* @test4(i32 %n) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[N:%.*]] to i64
; CHECK-NEXT:    [[A:%.*]] = alloca i32, i64 [[TMP1]], align 4
; CHECK-NEXT:    ret i32* [[A]]
;
; P32-LABEL: @test4(
; P32-NEXT:    [[A:%.*]] = alloca i32, i32 [[N:%.*]], align 4
; P32-NEXT:    ret i32* [[A]]
;
; NODL-LABEL: @test4(
; NODL-NEXT:    [[TMP1:%.*]] = zext i32 [[N:%.*]] to i64
; NODL-NEXT:    [[A:%.*]] = alloca i32, i64 [[TMP1]], align 4
; NODL-NEXT:    ret i32* [[A]]
;
  %A = alloca i32, i32 %n
  ret i32* %A
}

; Allocas which are only used by GEPs, bitcasts, addrspacecasts, and stores
; (transitively) should be deleted.
define void @test5() {
; ALL-LABEL: @test5(
; ALL-NEXT:  entry:
; ALL-NEXT:    ret void
;

entry:
  %a = alloca { i32 }
  %b = alloca i32*
  %c = alloca i32
  %a.1 = getelementptr { i32 }, { i32 }* %a, i32 0, i32 0
  store i32 123, i32* %a.1
  store i32* %a.1, i32** %b
  %b.1 = bitcast i32** %b to i32*
  store i32 123, i32* %b.1
  %a.2 = getelementptr { i32 }, { i32 }* %a, i32 0, i32 0
  store atomic i32 2, i32* %a.2 unordered, align 4
  %a.3 = getelementptr { i32 }, { i32 }* %a, i32 0, i32 0
  store atomic i32 3, i32* %a.3 release, align 4
  %a.4 = getelementptr { i32 }, { i32 }* %a, i32 0, i32 0
  store atomic i32 4, i32* %a.4 seq_cst, align 4
  %c.1 = addrspacecast i32* %c to i32 addrspace(1)*
  store i32 123, i32 addrspace(1)* %c.1
  ret void
}

declare void @f(i32* %p)

; Check that we don't delete allocas in some erroneous cases.
define void @test6() {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca { i32 }, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A_1:%.*]] = getelementptr inbounds { i32 }, { i32 }* [[A]], i64 0, i32 0
; CHECK-NEXT:    store volatile i32 123, i32* [[A_1]], align 4
; CHECK-NEXT:    tail call void @f(i32* nonnull [[B]])
; CHECK-NEXT:    ret void
;
; P32-LABEL: @test6(
; P32-NEXT:  entry:
; P32-NEXT:    [[A:%.*]] = alloca { i32 }, align 4
; P32-NEXT:    [[B:%.*]] = alloca i32, align 4
; P32-NEXT:    [[A_1:%.*]] = getelementptr inbounds { i32 }, { i32 }* [[A]], i32 0, i32 0
; P32-NEXT:    store volatile i32 123, i32* [[A_1]], align 4
; P32-NEXT:    tail call void @f(i32* nonnull [[B]])
; P32-NEXT:    ret void
;
; NODL-LABEL: @test6(
; NODL-NEXT:  entry:
; NODL-NEXT:    [[A:%.*]] = alloca { i32 }, align 8
; NODL-NEXT:    [[B:%.*]] = alloca i32, align 4
; NODL-NEXT:    [[A_1:%.*]] = getelementptr inbounds { i32 }, { i32 }* [[A]], i64 0, i32 0
; NODL-NEXT:    store volatile i32 123, i32* [[A_1]], align 8
; NODL-NEXT:    tail call void @f(i32* nonnull [[B]])
; NODL-NEXT:    ret void
;

entry:
  %a = alloca { i32 }
  %b = alloca i32
  %a.1 = getelementptr { i32 }, { i32 }* %a, i32 0, i32 0
  store volatile i32 123, i32* %a.1
  tail call void @f(i32* %b)
  ret void
}

; PR14371
%opaque_type = type opaque
%real_type = type { { i32, i32* } }

@opaque_global = external constant %opaque_type, align 4

define void @test7() {
; ALL-LABEL: @test7(
; ALL-NEXT:  entry:
; ALL-NEXT:    ret void
;
entry:
  %0 = alloca %real_type, align 4
  %1 = bitcast %real_type* %0 to i8*
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* %1, i8* bitcast (%opaque_type* @opaque_global to i8*), i32 8, i1 false)
  ret void
}

declare void @llvm.memcpy.p0i8.p0i8.i32(i8* nocapture, i8* nocapture, i32, i1) nounwind


; Check that the GEP indices use the pointer size, or 64 if unknown
define void @test8() {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    [[X1:%.*]] = alloca [100 x i32], align 4
; CHECK-NEXT:    [[X1_SUB:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[X1]], i64 0, i64 0
; CHECK-NEXT:    call void (...) @use(i32* nonnull [[X1_SUB]])
; CHECK-NEXT:    ret void
;
; P32-LABEL: @test8(
; P32-NEXT:    [[X1:%.*]] = alloca [100 x i32], align 4
; P32-NEXT:    [[X1_SUB:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[X1]], i32 0, i32 0
; P32-NEXT:    call void (...) @use(i32* nonnull [[X1_SUB]])
; P32-NEXT:    ret void
;
; NODL-LABEL: @test8(
; NODL-NEXT:    [[X1:%.*]] = alloca [100 x i32], align 4
; NODL-NEXT:    [[X1_SUB:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[X1]], i64 0, i64 0
; NODL-NEXT:    call void (...) @use(i32* nonnull [[X1_SUB]])
; NODL-NEXT:    ret void
;


  %x = alloca i32, i32 100
  call void (...) @use(i32* %x)
  ret void
}

; PR19569
%struct_type = type { i32, i32 }
declare void @test9_aux(<{ %struct_type }>* inalloca)
declare i8* @llvm.stacksave()
declare void @llvm.stackrestore(i8*)

define void @test9(%struct_type* %a) {
; ALL-LABEL: @test9(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[ARGMEM:%.*]] = alloca inalloca i64, align 8
; ALL-NEXT:    [[TMPCAST:%.*]] = bitcast i64* [[ARGMEM]] to <{ [[STRUCT_TYPE:%.*]] }>*
; ALL-NEXT:    [[TMP0:%.*]] = bitcast %struct_type* [[A:%.*]] to i64*
; ALL-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TMP0]], align 4
; ALL-NEXT:    store i64 [[TMP1]], i64* [[ARGMEM]], align 8
; ALL-NEXT:    call void @test9_aux(<{ [[STRUCT_TYPE]] }>* inalloca nonnull [[TMPCAST]])
; ALL-NEXT:    ret void
;
entry:
  %inalloca.save = call i8* @llvm.stacksave()
  %argmem = alloca inalloca <{ %struct_type }>
  %0 = getelementptr inbounds <{ %struct_type }>, <{ %struct_type }>* %argmem, i32 0, i32 0
  %1 = bitcast %struct_type* %0 to i8*
  %2 = bitcast %struct_type* %a to i8*
  call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 %1, i8* align 4 %2, i32 8, i1 false)
  call void @test9_aux(<{ %struct_type }>* inalloca %argmem)
  call void @llvm.stackrestore(i8* %inalloca.save)
  ret void
}

define void @test10() {
; ALL-LABEL: @test10(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[V32:%.*]] = alloca i1, align 8
; ALL-NEXT:    [[V64:%.*]] = alloca i1, align 8
; ALL-NEXT:    [[V33:%.*]] = alloca i1, align 8
; ALL-NEXT:    call void (...) @use(i1* nonnull [[V32]], i1* nonnull [[V64]], i1* nonnull [[V33]])
; ALL-NEXT:    ret void
;
entry:
  %v32 = alloca i1, align 8
  %v64 = alloca i1, i64 1, align 8
  %v33 = alloca i1, i33 1, align 8
  call void (...) @use(i1* %v32, i1* %v64, i1* %v33)
  ret void
}

define void @test11() {
; ALL-LABEL: @test11(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[Y:%.*]] = alloca i32, align 4
; ALL-NEXT:    call void (...) @use(i32* nonnull @int) [ "blah"(i32* [[Y]]) ]
; ALL-NEXT:    ret void
;
entry:
  %y = alloca i32
  call void (...) @use(i32* nonnull @int) [ "blah"(i32* %y) ]
  ret void
}
