/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (c) 2022 Analog Devices Inc. */

#ifndef _MAX98363_H
#define _MAX98363_H

#define MAX98363_R2000_SW_RESET			0x2000
#define MAX98363_R2001_INTR_RAW			0x2001
#define MAX98363_R2003_INTR_STATE		0x2003
#define MAX98363_R2005_INTR_FALG		0x2005
#define MAX98363_R2007_INTR_EN			0x2007
#define MAX98363_R2009_INTR_CLR			0x2009
#define MAX98363_R2021_ERR_MON_CTRL		0x2021
#define MAX98363_R2022_SPK_MON_THRESH		0x2022
#define MAX98363_R2023_SPK_MON_DURATION		0x2023
#define MAX98363_R2030_TONE_GEN_CFG		0x2030
#define MAX98363_R203F_TONE_GEN_EN		0x203F
#define MAX98363_R2040_AMP_VOL			0x2040
#define MAX98363_R2041_AMP_GAIN			0x2041
#define MAX98363_R2042_DSP_CFG			0x2042
#define MAX98363_R21FF_REV_ID			0x21FF

/* MAX98363_R2021_ERR_MON_CTRL */
#define MAX98363_SPKMON_SHIFT			(3)
#define MAX98363_CLOCK_MON_SHIFT		(0)

/* MAX98363_R2042_DSP_CFG */
#define MAX98363_AMP_DSP_CFG_RMP_SHIFT		(3)

struct max98363_priv {
	struct regmap *regmap;
	struct sdw_slave *slave;
	bool hw_init;
	bool first_hw_init;
};
#endif
