/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/* Copyright (c) 2025, NVIDIA CORPORATION. All rights reserved. */

#ifndef DT_BINDINGS_MEMORY_NVIDIA_TEGRA264_H
#define DT_BINDINGS_MEMORY_NVIDIA_TEGRA264_H

#define TEGRA264_SID(x) ((x) << 8)

/*
 * SMMU stream IDs
 */

#define TEGRA264_SID_AON       TEGRA264_SID(0x01)
#define TEGRA264_SID_APE       TEGRA264_SID(0x02)
#define TEGRA264_SID_ETR       TEGRA264_SID(0x03)
#define TEGRA264_SID_BPMP      TEGRA264_SID(0x04)
#define TEGRA264_SID_DCE       TEGRA264_SID(0x05)
#define TEGRA264_SID_EQOS      TEGRA264_SID(0x06)
#define TEGRA264_SID_GPCDMA    TEGRA264_SID(0x08)
#define TEGRA264_SID_DISP      TEGRA264_SID(0x09)
#define TEGRA264_SID_HDA       TEGRA264_SID(0x0a)
#define TEGRA264_SID_HOST1X    TEGRA264_SID(0x0b)
#define TEGRA264_SID_ISP0      TEGRA264_SID(0x0c)
#define TEGRA264_SID_ISP1      TEGRA264_SID(0x0d)
#define TEGRA264_SID_PMA0      TEGRA264_SID(0x0e)
#define TEGRA264_SID_FSI0      TEGRA264_SID(0x0f)
#define TEGRA264_SID_FSI1      TEGRA264_SID(0x10)
#define TEGRA264_SID_PVA       TEGRA264_SID(0x11)
#define TEGRA264_SID_SDMMC0    TEGRA264_SID(0x12)
#define TEGRA264_SID_MGBE0     TEGRA264_SID(0x13)
#define TEGRA264_SID_MGBE1     TEGRA264_SID(0x14)
#define TEGRA264_SID_MGBE2     TEGRA264_SID(0x15)
#define TEGRA264_SID_MGBE3     TEGRA264_SID(0x16)
#define TEGRA264_SID_MSSSEQ    TEGRA264_SID(0x17)
#define TEGRA264_SID_SE        TEGRA264_SID(0x18)
#define TEGRA264_SID_SEU1      TEGRA264_SID(0x19)
#define TEGRA264_SID_SEU2      TEGRA264_SID(0x1a)
#define TEGRA264_SID_SEU3      TEGRA264_SID(0x1b)
#define TEGRA264_SID_PSC       TEGRA264_SID(0x1c)
#define TEGRA264_SID_OESP      TEGRA264_SID(0x23)
#define TEGRA264_SID_SB        TEGRA264_SID(0x24)
#define TEGRA264_SID_XSPI0     TEGRA264_SID(0x25)
#define TEGRA264_SID_TSEC      TEGRA264_SID(0x29)
#define TEGRA264_SID_UFS       TEGRA264_SID(0x2a)
#define TEGRA264_SID_RCE       TEGRA264_SID(0x2b)
#define TEGRA264_SID_RCE1      TEGRA264_SID(0x2c)
#define TEGRA264_SID_VI        TEGRA264_SID(0x2e)
#define TEGRA264_SID_VI1       TEGRA264_SID(0x2f)
#define TEGRA264_SID_VIC       TEGRA264_SID(0x30)
#define TEGRA264_SID_XUSB_DEV  TEGRA264_SID(0x32)
#define TEGRA264_SID_XUSB_DEV1 TEGRA264_SID(0x33)
#define TEGRA264_SID_XUSB_DEV2 TEGRA264_SID(0x34)
#define TEGRA264_SID_XUSB_DEV3 TEGRA264_SID(0x35)
#define TEGRA264_SID_XUSB_DEV4 TEGRA264_SID(0x36)
#define TEGRA264_SID_XUSB_DEV5 TEGRA264_SID(0x37)

/*
 * memory client IDs
 */

/* HOST1X read client */
#define TEGRA264_MEMORY_CLIENT_HOST1XR		0x16
/* VIC read client */
#define TEGRA264_MEMORY_CLIENT_VICR		0x6c
/* VIC Write client */
#define TEGRA264_MEMORY_CLIENT_VICW		0x6d
/* VI R5 Write client */
#define TEGRA264_MEMORY_CLIENT_VIW		0x72
#define TEGRA264_MEMORY_CLIENT_NVDECSRD2MC	0x78
#define TEGRA264_MEMORY_CLIENT_NVDECSWR2MC	0x79
/* Audio processor(APE) Read client */
#define TEGRA264_MEMORY_CLIENT_APER		0x7a
/* Audio processor(APE) Write client */
#define TEGRA264_MEMORY_CLIENT_APEW		0x7b
/* Audio DMA Read client */
#define TEGRA264_MEMORY_CLIENT_APEDMAR		0x9f
/* Audio DMA Write client */
#define TEGRA264_MEMORY_CLIENT_APEDMAW		0xa0
#define TEGRA264_MEMORY_CLIENT_GPUR02MC		0xb6
#define TEGRA264_MEMORY_CLIENT_GPUW02MC		0xb7
/* VI Falcon Read client */
#define TEGRA264_MEMORY_CLIENT_VIFALCONR	0xbc
/* VI Falcon Write client */
#define TEGRA264_MEMORY_CLIENT_VIFALCONW	0xbd
/* Read Client of RCE */
#define TEGRA264_MEMORY_CLIENT_RCER		0xd2
/* Write client of RCE */
#define TEGRA264_MEMORY_CLIENT_RCEW		0xd3
/* PCIE0/MSI Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE0W		0xd9
/* PCIE1/RPX4 Read clients */
#define TEGRA264_MEMORY_CLIENT_PCIE1R		0xda
/* PCIE1/RPX4 Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE1W		0xdb
/* PCIE2/DMX4 Read clients */
#define TEGRA264_MEMORY_CLIENT_PCIE2AR		0xdc
/* PCIE2/DMX4 Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE2AW		0xdd
/* PCIE3/RPX4 Read clients */
#define TEGRA264_MEMORY_CLIENT_PCIE3R		0xde
/* PCIE3/RPX4 Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE3W		0xdf
/* PCIE4/DMX8 Read clients */
#define TEGRA264_MEMORY_CLIENT_PCIE4R		0xe0
/* PCIE4/DMX8 Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE4W		0xe1
/* PCIE5/DMX4 Read clients */
#define TEGRA264_MEMORY_CLIENT_PCIE5R		0xe2
/* PCIE5/DMX4 Write clients */
#define TEGRA264_MEMORY_CLIENT_PCIE5W		0xe3
/* UFS Read client */
#define TEGRA264_MEMORY_CLIENT_UFSR		0x15c
/* UFS write client */
#define TEGRA264_MEMORY_CLIENT_UFSW		0x15d
/* HDA Read client */
#define TEGRA264_MEMORY_CLIENT_HDAR		0x17c
/* HDA Write client */
#define TEGRA264_MEMORY_CLIENT_HDAW		0x17d
/* Disp ISO Read Client */
#define TEGRA264_MEMORY_CLIENT_DISPR		0x182
/* MGBE0 Read mccif */
#define TEGRA264_MEMORY_CLIENT_MGBE0R		0x1a2
/* MGBE0 Write mccif */
#define TEGRA264_MEMORY_CLIENT_MGBE0W		0x1a3
/* MGBE1 Read mccif */
#define TEGRA264_MEMORY_CLIENT_MGBE1R		0x1a4
/* MGBE1 Write mccif */
#define TEGRA264_MEMORY_CLIENT_MGBE1W		0x1a5
/* VI1 R5 Write client */
#define TEGRA264_MEMORY_CLIENT_VI1W		0x1a6
/* SDMMC0 Read mccif */
#define TEGRA264_MEMORY_CLIENT_SDMMC0R		0x1c2
/* SDMMC0 Write mccif */
#define TEGRA264_MEMORY_CLIENT_SDMMC0W		0x1c3

#endif /* DT_BINDINGS_MEMORY_NVIDIA_TEGRA264_H */
